/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.sql.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.base.model.Direction;
import org.openurp.edu.base.model.EduLevelBasedObject;
import org.openurp.edu.base.model.Instructor;
import org.openurp.edu.base.model.Major;
import org.openurp.edu.base.model.Program;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.base.model.StudentState;
import org.openurp.edu.base.model.Teacher;

@Entity(name="org.openurp.edu.base.model.Squad")
@Cacheable
@Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Squad
extends EduLevelBasedObject<Integer> {
    private static final long serialVersionUID = 6467000522483394459L;
    @Column(unique=true)
    @NotNull
    @Size(max=32)
    protected String code;
    @NotNull
    @Size(max=50)
    protected String name;
    @Size(max=50)
    protected String shortName;
    @Size(max=500)
    protected String remark;
    @NotNull
    @Size(max=10)
    private String grade;
    @ManyToOne(fetch=FetchType.LAZY)
    private Department department;
    @ManyToOne(fetch=FetchType.LAZY)
    private Major major;
    @ManyToOne(fetch=FetchType.LAZY)
    private Direction direction;
    @ManyToOne(fetch=FetchType.LAZY)
    private StdType stdType;
    private int planCount;
    @NotNull
    private Date beginOn;
    private Date endOn;
    @NotNull
    private int stdCount;
    @ManyToOne(fetch=FetchType.LAZY)
    private Instructor instructor;
    @ManyToOne(fetch=FetchType.LAZY)
    private Teacher tutor = null;
    @OneToMany(mappedBy="squad")
    private Set<StudentState> stdStates = CollectUtils.newHashSet();
    @ManyToOne(fetch=FetchType.LAZY)
    private Program program;
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;

    public Squad() {
    }

    public Squad(Integer id) {
        super(id);
    }

    public Squad(Integer id, String code, String name) {
        super(id);
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Major getMajor() {
        return this.major;
    }

    public void setMajor(Major major) {
        this.major = major;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public int getPlanCount() {
        return this.planCount;
    }

    public void setPlanCount(int planCount) {
        this.planCount = planCount;
    }

    public StdType getStdType() {
        return this.stdType;
    }

    public void setStdType(StdType stdType) {
        this.stdType = stdType;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public int getStdCount() {
        return this.stdCount;
    }

    public void setStdCount(int stdCount) {
        this.stdCount = stdCount;
    }

    public Instructor getInstructor() {
        return this.instructor;
    }

    public void setInstructor(Instructor instructor) {
        this.instructor = instructor;
    }

    public Teacher getTutor() {
        return this.tutor;
    }

    public void setTutor(Teacher tutor) {
        this.tutor = tutor;
    }

    public Set<Student> getAllStudents() {
        HashSet<Student> students = new HashSet<Student>();
        for (StudentState ss : this.stdStates) {
            students.add(ss.getStd());
        }
        return students;
    }

    public Set<Student> getStudents(Date date) {
        HashSet<Student> students = new HashSet<Student>();
        for (StudentState ss : this.stdStates) {
            if (!ss.isValid(date)) continue;
            students.add(ss.getStd());
        }
        return students;
    }

    public Set<StudentState> getStdStates() {
        return this.stdStates;
    }

    public void setStdStates(Set<StudentState> stdStates) {
        this.stdStates = stdStates;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }
}

