/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.NaturalId;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.GradeType;
import org.openurp.edu.base.code.model.CourseType;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.grade.AbstractGrade;
import org.openurp.edu.grade.Grade;
import org.openurp.edu.grade.course.model.ExamGrade;
import org.openurp.edu.grade.course.model.GaGrade;

@Entity(name="org.openurp.edu.grade.course.model.CourseGrade")
public class CourseGrade
extends AbstractGrade {
    private static final long serialVersionUID = 1L;
    @NaturalId(mutable=true)
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Course course;
    private String crn;
    @ManyToOne(fetch=FetchType.LAZY)
    private Clazz clazz;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseType courseType;
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseTakeType courseTakeType;
    @OneToMany(mappedBy="courseGrade", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    private Set<ExamGrade> examGrades = CollectUtils.newHashSet();
    @OneToMany(mappedBy="courseGrade", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    private Set<GaGrade> gaGrades = CollectUtils.newHashSet();
    private Float gp;
    private transient Map<GradeType, Grade> gradeMap;
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamMode examMode;
    private boolean freeListening;
    @Size(max=255)
    private String remark;
    private Date createdAt;

    public CourseGrade() {
    }

    public CourseGrade(CourseTaker taker) {
        this.setStd(taker.getStd());
        this.setClazz(taker.getClazz());
        this.setCrn(this.clazz.getCrn());
        this.setSemester(this.clazz.getSemester());
        this.setCourse(this.clazz.getCourse());
        this.setCourseType(this.clazz.getCourseType());
        this.setCourseTakeType(taker.getTakeType());
        this.setFreeListening(taker.isFreeListening());
        this.setCreatedAt(new Date());
    }

    private Map<GradeType, Grade> getGradeMap() {
        if (null == this.gradeMap || this.gradeMap.size() != this.examGrades.size() + this.gaGrades.size()) {
            this.gradeMap = new HashMap<GradeType, Grade>();
            for (ExamGrade examGrade : this.examGrades) {
                this.gradeMap.put(examGrade.getGradeType(), examGrade);
            }
            for (GaGrade gaGrade : this.gaGrades) {
                this.gradeMap.put(gaGrade.getGradeType(), gaGrade);
            }
        }
        return this.gradeMap;
    }

    public Grade getGrade(GradeType gradeType) {
        return this.getGradeMap().get((Object)gradeType);
    }

    public ExamGrade getExamGrade(GradeType gradeType) {
        if (gradeType.isGa()) {
            throw new RuntimeException(gradeType.getId() + " is not a exam grade   type.");
        }
        return (ExamGrade)this.getGradeMap().get((Object)gradeType);
    }

    public GaGrade getGaGrade(GradeType gradeType) {
        if (!gradeType.isGa()) {
            throw new RuntimeException(gradeType.getId() + " is not a gA grade   type.");
        }
        return (GaGrade)this.getGradeMap().get((Object)gradeType);
    }

    public CourseGrade addExamGrade(ExamGrade examGrade) {
        this.getExamGrades().add(examGrade);
        this.gradeMap = null;
        examGrade.setCourseGrade(this);
        return this;
    }

    public CourseGrade addGaGrade(GaGrade gaGrade) {
        this.getGaGrades().add(gaGrade);
        this.gradeMap = null;
        gaGrade.setCourseGrade(this);
        return this;
    }

    public String getScoreText(GradeType gradeType, Integer status) {
        String score = null;
        if (((Integer)gradeType.getId()).equals(GradeType.FINAL_ID)) {
            score = this.getScoreText();
        } else {
            Grade grade = this.getGrade(gradeType);
            if (null == grade) {
                return null;
            }
            if (null == status || status.intValue() == grade.getStatus()) {
                score = grade.getScoreText();
            }
        }
        return score;
    }

    public String getScoreText(GradeType gradeType) {
        return this.getScoreText(gradeType, null);
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public CourseType getCourseType() {
        return this.courseType;
    }

    public void setCourseType(CourseType courseType) {
        this.courseType = courseType;
    }

    public Float getGp() {
        return this.gp;
    }

    public void setGp(Float gp) {
        this.gp = gp;
    }

    public Set<ExamGrade> getExamGrades() {
        return this.examGrades;
    }

    public void setExamGrades(Set<ExamGrade> examGrades) {
        this.examGrades = examGrades;
    }

    public CourseTakeType getCourseTakeType() {
        return this.courseTakeType;
    }

    public void setCourseTakeType(CourseTakeType courseTakeType) {
        this.courseTakeType = courseTakeType;
    }

    public String getCrn() {
        return this.crn;
    }

    public void setCrn(String lessonNo) {
        this.crn = lessonNo;
    }

    public ExamMode getExamMode() {
        return this.examMode;
    }

    public void setExamMode(ExamMode examMode) {
        this.examMode = examMode;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Set<GaGrade> getGaGrades() {
        return this.gaGrades;
    }

    public void setGaGrades(Set<GaGrade> gaGrades) {
        this.gaGrades = gaGrades;
    }

    public boolean isFreeListening() {
        return this.freeListening;
    }

    public void setFreeListening(boolean freeListening) {
        this.freeListening = freeListening;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }
}

