/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.io.Serializable;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.Embeddable;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.beangle.commons.entity.Component;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.time.WeekDay;
import org.beangle.commons.lang.time.WeekState;
import org.beangle.commons.lang.time.Weeks;
import org.hibernate.annotations.Type;

@Embeddable
public class WeekTime
implements Component,
Comparable<WeekTime>,
Serializable {
    private static final long serialVersionUID = -2024647580747669114L;
    private Date startOn;
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute beginAt;
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute endAt;
    @Type(type="org.beangle.commons.lang.time.hibernate.WeekStateType")
    private WeekState weekstate;

    @Override
    public int compareTo(WeekTime other) {
        return new CompareToBuilder().append((Object)this.startOn, (Object)other.startOn).append((Object)this.beginAt, (Object)other.beginAt).append((Object)this.endAt, (Object)other.endAt).toComparison();
    }

    public int miniutes() {
        return this.endAt.interval(this.beginAt);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.weekstate == null ? 0 : this.weekstate.hashCode());
        result = prime * result + (this.beginAt == null ? 0 : this.beginAt.hashCode());
        result = prime * result + (this.endAt == null ? 0 : this.endAt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WeekTime) {
            WeekTime wt = (WeekTime)obj;
            return new EqualsBuilder().append((Object)this.beginAt, (Object)wt.beginAt).append((Object)this.endAt, (Object)wt.endAt).append((Object)this.weekstate, (Object)wt.weekstate).append((Object)this.startOn, (Object)wt.startOn).isEquals();
        }
        return false;
    }

    public WeekTime() {
    }

    public WeekTime(WeekTime other) {
        this.beginAt = other.beginAt;
        this.endAt = other.endAt;
        this.weekstate = other.weekstate;
        this.startOn = other.startOn;
    }

    public List<Date> getDates() {
        ArrayList<Date> dates = new ArrayList<Date>();
        LocalDate start = this.startOn.toLocalDate();
        for (Integer weekIndex : this.weekstate.getWeekList()) {
            dates.add(Date.valueOf(start.plusWeeks(weekIndex - 1)));
        }
        return dates;
    }

    public Date getDate(int week) {
        LocalDate start = this.startOn.toLocalDate();
        return Date.valueOf(start.plusWeeks(week - 1));
    }

    public boolean isOverlap(WeekTime time) {
        return (time.getWeekstate().value & this.getWeekstate().value) > 0L && time.getStartOn().equals(this.getStartOn()) && time.getBeginAt().le(this.getEndAt()) && time.getEndAt().ge(this.getBeginAt());
    }

    public WeekDay getWeekday() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.getStartOn());
        return WeekDay.getDayByJdkIndex(c.get(7));
    }

    public Object clone() {
        WeekTime time = new WeekTime();
        time.setWeekstate(this.getWeekstate());
        time.setBeginAt(this.getBeginAt());
        time.setEndAt(this.getEndAt());
        time.setStartOn(this.getStartOn());
        return time;
    }

    public int getStartYear() {
        if (null == this.startOn) {
            return 0;
        }
        return this.startOn.getYear() + 1900;
    }

    public Date getStartOn() {
        return this.startOn;
    }

    public void setStartOn(Date startOn) {
        this.startOn = startOn;
    }

    public HourMinute getBeginAt() {
        return this.beginAt;
    }

    public void setBeginAt(HourMinute beginAt) {
        this.beginAt = beginAt;
    }

    public HourMinute getEndAt() {
        return this.endAt;
    }

    public void setEndAt(HourMinute endAt) {
        this.endAt = endAt;
    }

    public WeekState getWeekstate() {
        return this.weekstate;
    }

    public void setWeekstate(WeekState weekstate) {
        this.weekstate = weekstate;
    }

    public Date getFirstDay() {
        if (null != this.getWeekstate()) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setMinimalDaysInFirstWeek(1);
            gc.setTime(this.getStartOn());
            gc.add(3, this.getWeekstate().getWeekList().get(0) - 1);
            gc.set(11, 0);
            gc.set(12, 0);
            gc.set(13, 0);
            gc.set(14, 0);
            return new Date(gc.getTime().getTime());
        }
        return null;
    }

    public String getTimeZone() {
        if (null != this.getBeginAt() && null != this.getEndAt()) {
            return this.getBeginAt() + "-" + this.getEndAt();
        }
        return "";
    }

    public String toString() {
        return "[startOn:" + this.getStartOn() + " beginAt:" + this.getBeginAt() + " endAt:" + this.getEndAt() + " weeks:" + this.getWeekstate() + "]";
    }

    public static LocalDate getStartOn(int year, WeekDay weekday) {
        LocalDate startDate = LocalDate.of(year, 1, 1);
        while (startDate.getDayOfWeek().getValue() != ((Integer)weekday.getId()).intValue()) {
            startDate = startDate.plusDays(1L);
        }
        return startDate;
    }

    public static WeekTime of(Date date) {
        LocalDate ld = date.toLocalDate();
        LocalDate yearStartOn = WeekTime.getStartOn(ld.getYear(), WeekDay.get(ld.getDayOfWeek().getValue()));
        WeekTime weektime = new WeekTime();
        weektime.setStartOn(Date.valueOf(yearStartOn));
        weektime.setWeekstate(WeekState.of(Weeks.between(yearStartOn, ld) + 1));
        return weektime;
    }

    public boolean contains(Date date) {
        WeekTime wt = WeekTime.of(date);
        return wt.getStartOn().equals(this.getStartOn()) && (wt.getWeekstate().value & this.getWeekstate().value) > 0L;
    }

    public Date getLastDay() {
        if (null != this.getWeekstate()) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(this.getStartOn());
            gc.add(3, this.getWeekstate().getLast() - 1);
            gc.set(11, this.getBeginAt().value / 100);
            gc.set(12, this.getBeginAt().value % 100);
            return new Date(gc.getTime().getTime());
        }
        return null;
    }

    public void dropDay(Date lastDay) {
        int weeks;
        LocalDate start = this.startOn.toLocalDate();
        LocalDate end = lastDay.toLocalDate();
        if (end.getDayOfWeek() == start.getDayOfWeek() && (weeks = Weeks.between(start, end) + 1) <= 63 && weeks >= 0 && this.weekstate.isOccupied(weeks)) {
            this.weekstate = this.weekstate.bitxor(WeekState.of(weeks));
        }
    }

    public void addDay(Date lastDay) {
        int weeks;
        LocalDate start = this.startOn.toLocalDate();
        LocalDate end = lastDay.toLocalDate();
        if (end.getDayOfWeek() == start.getDayOfWeek() && (weeks = Weeks.between(start, end) + 1) <= 53 && weeks >= 0 && !this.weekstate.isOccupied(weeks)) {
            this.weekstate = this.weekstate.bitor(WeekState.of(weeks));
        }
    }
}

