/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.sql.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.time.HourMinute;
import org.hibernate.annotations.Type;
import org.openurp.base.model.Building;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.ClassroomType;
import org.openurp.code.edu.model.ExamType;
import org.openurp.edu.base.model.Classroom;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.base.model.Project;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.exam.model.ExamActivity;
import org.openurp.edu.exam.model.ExamGroup;
import org.openurp.edu.exam.model.RoomGroup;

@Entity(name="org.openurp.edu.exam.model.ExamTask")
public class ExamTask
extends LongIdObject {
    private static final long serialVersionUID = -5162834520002681798L;
    @NotNull
    @Size(max=300)
    private String code;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Department teachDepart;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamType examType;
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamGroup group;
    @OneToMany(mappedBy="task")
    @OrderBy(value="stdCount DESC")
    private List<ExamActivity> activities = CollectUtils.newArrayList();
    private Date examOn;
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute beginAt = HourMinute.Zero;
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute endAt = HourMinute.Zero;
    private boolean timeAllotted;
    private int stdCount;
    @ManyToOne(fetch=FetchType.LAZY)
    private Building building;
    @ManyToOne(fetch=FetchType.LAZY)
    private RoomGroup roomGroup;
    @ManyToMany
    private Set<Classroom> rooms = CollectUtils.newHashSet();
    @Size(max=255)
    private String remark;
    private Float maxCourseConflictRatio;
    @ManyToOne(fetch=FetchType.LAZY)
    private ClassroomType roomType;
    private short duration;
    private Short examWeek;
    private boolean departArranged;

    public boolean isEmptyTime() {
        return null == this.beginAt && null == this.endAt || this.beginAt.value == 0 && this.endAt.value == 0;
    }

    public Department getTeachDepart() {
        return this.teachDepart;
    }

    public void setTeachDepart(Department teachDepart) {
        this.teachDepart = teachDepart;
    }

    public Map<Campus, Integer> getCampusStdCounts() {
        Map counts = CollectUtils.newHashMap();
        for (ExamActivity ea : this.activities) {
            Integer c = (Integer)counts.get(ea.getClazz().getCampus());
            if (null == c) {
                counts.put(ea.getClazz().getCampus(), ea.getStdCount());
                continue;
            }
            counts.put(ea.getClazz().getCampus(), ea.getStdCount() + c);
        }
        return counts;
    }

    public void calcStdCount() {
        int a = 0;
        for (ExamActivity el : this.activities) {
            a += el.getStdCount();
        }
        this.stdCount = a;
    }

    public void buildCode() {
        this.code = this.getCourseCodes();
    }

    public List<Clazz> getClazzes() {
        List clazzes = CollectUtils.newArrayList();
        for (ExamActivity ea : this.activities) {
            clazzes.add(ea.getClazz());
        }
        return clazzes;
    }

    public int getStdCount() {
        return this.stdCount;
    }

    public void setStdCount(int stdCount) {
        this.stdCount = stdCount;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public ExamType getExamType() {
        return this.examType;
    }

    public void setExamType(ExamType examType) {
        this.examType = examType;
    }

    public Date getExamOn() {
        return this.examOn;
    }

    public void setExamOn(Date examOn) {
        this.examOn = examOn;
    }

    public HourMinute getBeginAt() {
        return this.beginAt;
    }

    public void setBeginAt(HourMinute beginAt) {
        this.beginAt = beginAt;
    }

    public HourMinute getEndAt() {
        return this.endAt;
    }

    public void setEndAt(HourMinute endAt) {
        this.endAt = endAt;
    }

    public Building getBuilding() {
        return this.building;
    }

    public void setBuilding(Building building) {
        this.building = building;
    }

    public Set<Classroom> getRooms() {
        return this.rooms;
    }

    public void setRooms(Set<Classroom> rooms) {
        this.rooms = rooms;
    }

    public RoomGroup getRoomGroup() {
        return this.roomGroup;
    }

    public void setRoomGroup(RoomGroup roomGroup) {
        this.roomGroup = roomGroup;
    }

    public ExamGroup getGroup() {
        return this.group;
    }

    public void setGroup(ExamGroup session) {
        this.group = session;
    }

    public String toString() {
        return "id:" + this.id;
    }

    public Float getMaxCourseConflictRatio() {
        return this.maxCourseConflictRatio;
    }

    public void setMaxCourseConflictRatio(Float maxCourseConflictRatio) {
        this.maxCourseConflictRatio = maxCourseConflictRatio;
    }

    public boolean isTimeAllotted() {
        return this.timeAllotted;
    }

    public void setTimeAllotted(boolean timeAllotted) {
        this.timeAllotted = timeAllotted;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Set<Course> getCourses() {
        Set cs = CollectUtils.newHashSet();
        for (ExamActivity ea : this.activities) {
            cs.add(ea.getClazz().getCourse());
        }
        return cs;
    }

    public String getCourseCodes() {
        HashSet<String> codes = new HashSet<String>();
        Set<Course> cs = this.getCourses();
        for (Course c : cs) {
            codes.add(c.getCode());
        }
        if (codes.size() == 1) {
            return (String)codes.iterator().next();
        }
        return Strings.join((Object[])codes.toArray(), (char)',');
    }

    public String getCourseNames() {
        HashSet<String> names = new HashSet<String>();
        Set<Course> cs = this.getCourses();
        for (Course c : cs) {
            names.add(c.getName());
        }
        if (names.size() == 1) {
            return (String)names.iterator().next();
        }
        return Strings.join((Object[])names.toArray(), (char)',');
    }

    public Short getExamWeek() {
        return this.examWeek;
    }

    public void setExamWeek(Short examWeek) {
        this.examWeek = examWeek;
    }

    public ClassroomType getRoomType() {
        return this.roomType;
    }

    public void setRoomType(ClassroomType roomType) {
        this.roomType = roomType;
    }

    public void setDuration(short duration) {
        this.duration = duration;
    }

    public short getDuration() {
        return this.duration;
    }

    public boolean isDepartArranged() {
        return this.departArranged;
    }

    public void setDepartArranged(boolean departArranged) {
        this.departArranged = departArranged;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<ExamActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<ExamActivity> activities) {
        this.activities = activities;
    }
}

