/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.program.plan.model.AbstractCoursePlan;
import org.openurp.edu.program.plan.model.CourseGroup;
import org.openurp.edu.program.plan.model.ExecuteCourseGroup;
import org.openurp.edu.program.plan.model.ExecutePlanComment;

@Entity(name="org.openurp.edu.program.plan.model.ExecutePlan")
@Cacheable
@Cache(region="edu.course", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ExecutePlan
extends AbstractCoursePlan {
    private static final long serialVersionUID = 7084539759992691314L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Department department;
    @ManyToOne(fetch=FetchType.LAZY)
    private StdType stdType;
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;
    @OneToMany(orphanRemoval=true, targetEntity=ExecuteCourseGroup.class, cascade={CascadeType.ALL})
    @JoinColumn(name="plan_id", nullable=false)
    @OrderBy(value="indexno")
    @Cache(region="edu.course", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<CourseGroup> groups = CollectUtils.newArrayList();
    @OneToMany(mappedBy="executePlan", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<ExecutePlanComment> comments = CollectUtils.newArrayList();
    @NotNull
    private Date beginOn;
    private Date endOn;

    @Override
    public List<CourseGroup> getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(List<CourseGroup> groups) {
        this.groups = groups;
    }

    public Object clone() throws CloneNotSupportedException {
        ExecutePlan copy = (ExecutePlan)super.clone();
        copy.setGroups(new ArrayList<CourseGroup>());
        copy.setId(null);
        return copy;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public StdType getStdType() {
        return this.stdType;
    }

    public void setStdType(StdType stdType) {
        this.stdType = stdType;
    }

    @Override
    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    @Override
    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public List<ExecutePlanComment> getComments() {
        return this.comments;
    }

    public void setComments(List<ExecutePlanComment> comments) {
        this.comments = comments;
    }

    public String toString() {
        return "ExecutePlanBean [program=" + this.program + ", startTerm=" + this.getStartTerm() + ", endTerm=" + this.getEndTerm() + "]";
    }
}

