/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.sql.Date;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.lang.time.WeekDay;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Type;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.base.model.School;
import org.openurp.edu.base.model.Semester;

@Entity(name="org.openurp.edu.base.model.Calendar")
@Cacheable
@Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Calendar
extends NumberIdTimeObject<Integer> {
    private static final long serialVersionUID = 3782522480625235916L;
    @NotNull
    @Size(max=50)
    @Column(unique=true)
    private String name;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private School school;
    @NotNull
    protected Date beginOn;
    protected Date endOn;
    @NotNull
    @Type(type="org.beangle.commons.lang.time.hibernate.WeekDayType")
    private WeekDay firstWeekday;
    @OneToMany(mappedBy="calendar", orphanRemoval=true)
    @OrderBy
    @Cascade(value={CascadeType.ALL})
    private List<Semester> semesters;

    public School getSchool() {
        return this.school;
    }

    public void setSchool(School school2) {
        this.school = school2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Semester> getSemesters() {
        return this.semesters;
    }

    public void setSemesters(List<Semester> semesters) {
        this.semesters = semesters;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public WeekDay getFirstWeekday() {
        return this.firstWeekday;
    }

    public void setFirstWeekday(WeekDay firstWeekday) {
        this.firstWeekday = firstWeekday;
    }

    public Semester getNearest() {
        long now = System.currentTimeMillis();
        long near = 0L;
        long temp = Long.MAX_VALUE;
        Date date = new Date(now);
        Semester nearnest = null;
        for (Semester semester : this.semesters) {
            long b;
            if (null != semester.getBeginOn() && date.toString().equals(semester.getBeginOn().toString()) || null != semester.getEndOn() && date.toString().equals(semester.getEndOn().toString())) {
                return semester;
            }
            long a = Math.abs(semester.getBeginOn().getTime() - now);
            near = a > (b = Math.abs(semester.getEndOn().getTime() - now)) ? b : a;
            if (near >= temp) continue;
            nearnest = semester;
            temp = near;
        }
        return nearnest;
    }
}

