/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.sql.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Building;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.model.Room;
import org.openurp.code.edu.model.ClassroomType;
import org.openurp.edu.base.model.ProjectBasedObject;

@Entity(name="org.openurp.edu.base.model.Classroom")
@Cacheable
@Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Classroom
extends ProjectBasedObject<Integer> {
    private static final long serialVersionUID = -296464887575077607L;
    @ManyToOne(fetch=FetchType.LAZY)
    private Room room;
    private String code;
    private String name;
    private String enName;
    private String shortName;
    @ManyToOne(fetch=FetchType.LAZY)
    private ClassroomType roomType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;
    private int courseCapacity;
    private int examCapacity;
    private Date beginOn;
    private Date endOn;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="openurp.base")
    private Set<Department> departs = new HashSet<Department>();

    public int getCapacity() {
        if (null == this.room) {
            return this.courseCapacity;
        }
        return this.room.getCapacity();
    }

    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public String getEnName() {
        return this.enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public ClassroomType getRoomType() {
        return this.roomType;
    }

    public void setRoomType(ClassroomType classroomType) {
        this.roomType = classroomType;
    }

    public int getCourseCapacity() {
        return this.courseCapacity;
    }

    public void setCourseCapacity(int courseCapacity) {
        this.courseCapacity = courseCapacity;
    }

    public int getExamCapacity() {
        return this.examCapacity;
    }

    public Building getBuilding() {
        return null == this.room ? null : this.room.getBuilding();
    }

    public void setExamCapacity(int examCapacity) {
        this.examCapacity = examCapacity;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public String getExamDescription() {
        return this.campus.getName() + " " + this.getName() + " " + this.getRoomType().getName() + "(" + this.getExamCapacity() + ")";
    }

    public Set<Department> getDeparts() {
        return this.departs;
    }

    public void setDeparts(Set<Department> departs) {
        this.departs = departs;
    }
}

