/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.sql.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.time.HourMinute;
import org.hibernate.annotations.Type;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.ExamType;
import org.openurp.edu.base.model.Classroom;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.exam.model.ExamActivity;
import org.openurp.edu.exam.model.ExamTaker;
import org.openurp.edu.exam.model.Invigilation;

@Entity(name="org.openurp.edu.exam.model.ExamRoom")
public class ExamRoom
extends LongIdObject {
    private static final long serialVersionUID = -4159480893203938576L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Department teachDepart;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamType examType;
    private Date examOn;
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute beginAt;
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute endAt;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    private Classroom room;
    private int stdCount;
    @ManyToMany(mappedBy="rooms")
    private Set<ExamActivity> activities = CollectUtils.newHashSet();
    @OneToMany(mappedBy="examRoom", orphanRemoval=true, targetEntity=Invigilation.class, cascade={CascadeType.ALL})
    private Set<Invigilation> invigilations = CollectUtils.newHashSet();
    @OneToMany(mappedBy="examRoom", targetEntity=ExamTaker.class)
    private Set<ExamTaker> examTakers = CollectUtils.newHashSet();

    public ExamRoom() {
    }

    public ExamRoom(ExamActivity activity, Classroom room) {
        this.semester = activity.getSemester();
        this.teachDepart = activity.getClazz().getTeachDepart();
        this.examOn = activity.getExamOn();
        this.beginAt = activity.getBeginAt();
        this.endAt = activity.getEndAt();
        this.room = room;
        this.activities.add(activity);
        activity.getRooms().add(this);
    }

    public Map<Course, List<ExamTaker>> getCourseStds() {
        Map courseStds = CollectUtils.newHashMap();
        for (ExamTaker es : this.getExamTakers()) {
            Course c = es.getClazz().getCourse();
            List stdList = (List)courseStds.get(c);
            if (null == stdList) {
                stdList = CollectUtils.newArrayList();
                courseStds.put(c, stdList);
            }
            stdList.add(es);
        }
        return courseStds;
    }

    public Department getTeachDepart() {
        return this.teachDepart;
    }

    public void setTeachDepart(Department teachDepart) {
        this.teachDepart = teachDepart;
    }

    public boolean isSameExcept(ExamRoom other, boolean room) {
        boolean sameRoom;
        if (room && !(sameRoom = Objects.equals((Object)this.getRoom(), (Object)other.getRoom()))) {
            return false;
        }
        return this.getExamOn().equals(other.getExamOn()) && this.getBeginAt().equals(other.getBeginAt()) && this.getEndAt().equals(other.getEndAt());
    }

    public int getStdCount() {
        return this.stdCount;
    }

    public void setStdCount(int stdCount) {
        this.stdCount = stdCount;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public ExamType getExamType() {
        return this.examType;
    }

    public void setExamType(ExamType examType) {
        this.examType = examType;
    }

    public Date getExamOn() {
        return this.examOn;
    }

    public void setExamOn(Date examOn) {
        this.examOn = examOn;
    }

    public HourMinute getBeginAt() {
        return this.beginAt;
    }

    public void setBeginAt(HourMinute beginAt) {
        this.beginAt = beginAt;
    }

    public HourMinute getEndAt() {
        return this.endAt;
    }

    public void setEndAt(HourMinute endAt) {
        this.endAt = endAt;
    }

    public Classroom getRoom() {
        return this.room;
    }

    public void setRoom(Classroom room) {
        this.room = room;
    }

    public Set<ExamActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(Set<ExamActivity> activities) {
        this.activities = activities;
    }

    public Set<Invigilation> getInvigilations() {
        return this.invigilations;
    }

    public void setInvigilations(Set<Invigilation> invigilations) {
        this.invigilations = invigilations;
    }

    public Set<ExamTaker> getExamTakers() {
        return this.examTakers;
    }

    public void setExamTakers(Set<ExamTaker> examTakers) {
        this.examTakers = examTakers;
    }

    public void addExamTaker(ExamTaker taker) {
        taker.setExamRoom(this);
        this.getExamTakers().add(taker);
    }

    public Object clone() {
        ExamRoom activity = new ExamRoom();
        activity.setExamOn(this.getExamOn());
        activity.setBeginAt(this.getBeginAt());
        activity.setEndAt(this.getEndAt());
        activity.setSemester(this.getSemester());
        return activity;
    }

    public Set<Clazz> getClazzes() {
        Set clazzes = CollectUtils.newHashSet();
        for (ExamActivity ea : this.activities) {
            clazzes.add(ea.getClazz());
        }
        return clazzes;
    }
}

