/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.model;

import java.util.Date;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.Model;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.openurp.base.model.User;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.grade.course.model.AbstractGradeState;
import org.openurp.edu.grade.course.model.ExamGradeState;
import org.openurp.edu.grade.course.model.GaGradeState;
import org.openurp.edu.grade.course.model.GradeState;

@Entity(name="org.openurp.edu.grade.course.model.CourseGradeState")
public class CourseGradeState
extends AbstractGradeState {
    private static final long serialVersionUID = 3297067284042522108L;
    @ManyToOne(fetch=FetchType.LAZY)
    private Clazz clazz;
    @OneToMany(mappedBy="gradeState", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    private Set<ExamGradeState> examStates = CollectUtils.newHashSet();
    @OneToMany(mappedBy="gradeState", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    private Set<GaGradeState> gaStates = CollectUtils.newHashSet();
    @ManyToOne(fetch=FetchType.LAZY)
    private User extraInputer;

    public CourseGradeState() {
    }

    public CourseGradeState(Clazz clazz) {
        this.clazz = clazz;
        this.setGradingMode(new GradingMode(GradingMode.Percent));
    }

    public void updateStatus(GradeType gradeType, int status) {
        GradeState state = this.getState(gradeType);
        if (null == state) {
            if (gradeType.isGa()) {
                GaGradeState gas = (GaGradeState)Model.newInstance(GaGradeState.class);
                gas.setGradeState(this);
                gas.setGradeType(gradeType);
                gas.setStatus(status);
                gas.setGradingMode(this.gradingMode);
                this.gaStates.add(gas);
                state = gas;
            } else {
                ExamGradeState egs = (ExamGradeState)Model.newInstance(ExamGradeState.class);
                egs.setGradeState(this);
                egs.setGradeType(gradeType);
                egs.setStatus(status);
                egs.setGradingMode(this.gradingMode);
                this.examStates.add(egs);
                state = egs;
            }
        } else {
            state.setStatus(status);
        }
    }

    public GradeState getState(GradeType gradeType) {
        if (gradeType.isGa()) {
            for (GaGradeState state : this.gaStates) {
                if (!((Integer)state.getGradeType().getId()).equals(gradeType.getId())) continue;
                return state;
            }
        } else {
            for (ExamGradeState state : this.examStates) {
                if (!((Integer)state.getGradeType().getId()).equals(gradeType.getId())) continue;
                return state;
            }
        }
        return null;
    }

    public GradeState getOrCreateState(GradeType gradeType) {
        if (gradeType.isGa()) {
            GaGradeState result = null;
            for (GaGradeState state : this.gaStates) {
                if (!((Integer)state.getGradeType().getId()).equals(gradeType.getId())) continue;
                result = state;
                break;
            }
            if (null == result) {
                result = new GaGradeState();
                result.setStatus(0);
                result.setUpdatedAt(new Date());
                result.setGradeType(gradeType);
                result.setGradeState(this);
                this.gaStates.add(result);
            }
            return result;
        }
        ExamGradeState result = null;
        for (ExamGradeState state : this.examStates) {
            if (!((Integer)state.getGradeType().getId()).equals(gradeType.getId())) continue;
            result = state;
            break;
        }
        if (null == result) {
            result = new ExamGradeState();
            result.setStatus(0);
            result.setUpdatedAt(new Date());
            result.setGradeType(gradeType);
            result.setGradeState(this);
            this.examStates.add(result);
        }
        return result;
    }

    public boolean isStatus(GradeType gradeType, int status) {
        GradeState gradeTypeState = this.getState(gradeType);
        if (null == gradeTypeState) {
            return false;
        }
        return gradeTypeState.getStatus() == status;
    }

    public Short getPercent(GradeType gradeType) {
        for (ExamGradeState gradeTypeState : this.examStates) {
            if (null == gradeType || !((Integer)gradeTypeState.getGradeType().getId()).equals(gradeType.getId())) continue;
            return gradeTypeState.getScorePercent();
        }
        return null;
    }

    public int getStatus(GradeType gradeType) {
        if (gradeType.isGa()) {
            for (GaGradeState egs : this.gaStates) {
                if (!((Integer)egs.getGradeType().getId()).equals(gradeType.getId())) continue;
                return egs.getStatus();
            }
        } else {
            for (ExamGradeState egs : this.examStates) {
                if (!((Integer)egs.getGradeType().getId()).equals(gradeType.getId())) continue;
                return egs.getStatus();
            }
        }
        return 0;
    }

    @Override
    public GradeType getGradeType() {
        return new GradeType(GradeType.FINAL_ID);
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public Set<ExamGradeState> getExamStates() {
        return this.examStates;
    }

    public void setExamStates(Set<ExamGradeState> states) {
        this.examStates = states;
    }

    public User getExtraInputer() {
        return this.extraInputer;
    }

    public void setExtraInputer(User extraInputer) {
        this.extraInputer = extraInputer;
    }

    public Set<GaGradeState> getGaStates() {
        return this.gaStates;
    }

    public void setGaStates(Set<GaGradeState> gaStates) {
        this.gaStates = gaStates;
    }

    public static enum AuditStatus {
        NEED_AUDIT("\u5f85\u5ba1\u6838"),
        DEPART_AUDIT_PASSED("\u5ba1\u6838\u901a\u8fc7"),
        DEPART_AUDIT_UNPASSED("\u5ba1\u6838\u672a\u901a\u8fc7"),
        NEED_FINAL_AUDIT("\u9662\u957f\u5ba1\u6838"),
        FINAL_AUDIT_PASSED("\u6700\u7ec8\u5ba1\u6838\u901a\u8fc7"),
        FINAL_AUDIT_UNPASSED("\u6700\u7ec8\u5ba1\u6838\u672a\u901a\u8fc7");

        private String fullName;

        private AuditStatus() {
        }

        private AuditStatus(String fullName) {
            this.fullName = fullName;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

