/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.security.service;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.web.util.HttpUtils;
import org.beangle.security.Securities;
import org.beangle.security.core.userdetail.DefaultAccount;
import org.beangle.security.core.userdetail.Profile;
import org.beangle.security.data.Permission;
import org.beangle.security.data.ProfileService;
import org.openurp.app.Ems;
import org.openurp.app.EmsApp;
import org.openurp.app.security.DataPermission;
import org.openurp.app.security.Dimension;
import org.openurp.app.security.service.UserDataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAuthorityService
implements ProfileService,
Initializing {
    private static final Logger logger = LoggerFactory.getLogger(RemoteAuthorityService.class);
    private Cache sysCache = null;
    private Map<String, Dimension> dimensionMap = CollectUtils.newHashMap();
    private UserDataResolver dataResolver;

    public void init() throws Exception {
        this.sysCache = CacheManager.getInstance().getCache("user_data_permission");
        if (null == this.sysCache) {
            throw new RuntimeException("Cannot find user_data_permission cache in ehcache.xml");
        }
    }

    public Dimension getDimension(String fieldName) {
        Dimension dimension = this.dimensionMap.get(fieldName);
        if (null == dimension) {
            String url = Ems.Instance.getApi() + "/platform/user/dimensions/" + fieldName + ".json";
            String resources = HttpUtils.getResponseText((String)url);
            Map rs = (Map)new Gson().fromJson(resources, Map.class);
            if (rs.isEmpty()) {
                return null;
            }
            dimension = this.toDimension(rs);
            this.dimensionMap.put(fieldName, dimension);
        }
        return dimension;
    }

    private Dimension toDimension(Map data) {
        Dimension dimension = new Dimension();
        Iterator iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            PropertyUtils.copyProperty((Object)((Object)dimension), (String)((String)entry.getKey()), entry.getValue());
        }
        dimension.setMultiple(true);
        return dimension;
    }

    public List<Profile> getProfiles(String userCode, String function) {
        DefaultAccount account = (DefaultAccount)Securities.getSession().getPrincipal();
        if (null == account.getProfiles()) {
            return Collections.emptyList();
        }
        return Arrays.asList(account.getProfiles());
    }

    public Permission getPermission(String user, String dataResource, String functionResource) {
        String key = user + "_" + dataResource;
        Element ele = this.sysCache.get((Serializable)((Object)key));
        if (null == ele) {
            String url = Ems.Instance.getApi() + "/platform/security/data/permissions/user/" + user + ".json?data=" + dataResource + "&app=" + EmsApp.getName();
            String resources = HttpUtils.getResponseText((String)url);
            Map rs = (Map)new Gson().fromJson(resources, Map.class);
            if (rs.isEmpty()) {
                return null;
            }
            DataPermission dp = new DataPermission();
            dp.setFilters((String)rs.get("filters"));
            dp.setActions((String)rs.get("actions"));
            this.sysCache.put(new Element((Serializable)((Object)key), (Serializable)dp));
            return dp;
        }
        return (DataPermission)ele.getValue();
    }

    private Object unmarshal(String value, Dimension property) {
        try {
            List returned = this.dataResolver.unmarshal(property, value);
            if (property.isMultiple()) {
                return returned;
            }
            return 1 != returned.size() ? null : returned.get(0);
        }
        catch (Exception e) {
            logger.error("exception with param type:" + property.getTypeName() + " value:" + value, (Throwable)e);
            return null;
        }
    }

    public String extractResource(String uri) {
        int lastDot = -1;
        for (int i = 0; i < uri.length(); ++i) {
            char a = uri.charAt(i);
            if (a != '.' && a != '!') continue;
            lastDot = i;
            break;
        }
        if (lastDot < 0) {
            lastDot = uri.length();
        }
        return uri.substring(0, lastDot);
    }

    public void setDataResolver(UserDataResolver dataResolver) {
        this.dataResolver = dataResolver;
    }
}

