/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Target;
import org.openurp.code.edu.model.Language;
import org.openurp.edu.base.code.model.CourseAbilityRate;
import org.openurp.edu.base.code.model.CourseType;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.ExecutionCourseGroup;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.SharePlan;
import org.openurp.edu.program.model.SharePlanCourse;

@Entity(name="org.openurp.edu.program.model.ShareCourseGroup")
public class ShareCourseGroup
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -6481752967441999886L;
    @Target(value=SharePlan.class)
    @ManyToOne(fetch=FetchType.LAZY)
    private SharePlan plan;
    @Size(max=30)
    @NotNull
    private String indexno;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected CourseType courseType;
    @Target(value=ShareCourseGroup.class)
    @ManyToOne(fetch=FetchType.LAZY)
    private ShareCourseGroup parent;
    @OneToMany(targetEntity=ShareCourseGroup.class, mappedBy="parent")
    @OrderBy(value="indexno")
    @Cascade(value={CascadeType.ALL})
    private List<ShareCourseGroup> children = CollectUtils.newArrayList();
    @OneToMany(mappedBy="group", targetEntity=SharePlanCourse.class)
    @Cascade(value={CascadeType.ALL})
    protected List<SharePlanCourse> planCourses = CollectUtils.newArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    protected Language language;
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseAbilityRate abilityRate;

    public String getIndexno() {
        return this.indexno;
    }

    public void setIndexno(String indexno) {
        this.indexno = indexno;
    }

    public CourseType getCourseType() {
        return this.courseType;
    }

    public void setCourseType(CourseType courseType) {
        this.courseType = courseType;
    }

    public Object clone() throws CloneNotSupportedException {
        ShareCourseGroup courseGroup = (ShareCourseGroup)super.clone();
        courseGroup.setId(null);
        List<ShareCourseGroup> groups = courseGroup.getChildren();
        List groupClones = CollectUtils.newArrayList();
        for (ShareCourseGroup cg : groups) {
            ShareCourseGroup groupClone = (ShareCourseGroup)cg.clone();
            groupClones.add(groupClone);
            groupClone.setParent(courseGroup);
        }
        courseGroup.setChildren(groupClones);
        courseGroup.setPlanCourses(new ArrayList<SharePlanCourse>());
        for (SharePlanCourse planCourse : this.getPlanCourses()) {
            courseGroup.addPlanCourse((SharePlanCourse)planCourse.clone());
        }
        return courseGroup;
    }

    public void addPlanCourse(SharePlanCourse planCourse) {
        for (SharePlanCourse planCourse1 : this.getPlanCourses()) {
            if (!planCourse.getCourse().equals(planCourse1.getCourse())) continue;
            return;
        }
        planCourse.setGroup(this);
        this.getPlanCourses().add(planCourse);
    }

    public Object cloneToExecuteCourseGroup() {
        ExecutionCourseGroup courseGroup = (ExecutionCourseGroup)Model.newInstance(ExecutionCourseGroup.class);
        courseGroup.setCourseType(this.getCourseType());
        courseGroup.setIndexno(this.getIndexno());
        courseGroup.setChildren(new ArrayList<CourseGroup>());
        courseGroup.setPlanCourses(new ArrayList<PlanCourse>());
        courseGroup.setId(null);
        return courseGroup;
    }

    public void setPlanCourses(List<SharePlanCourse> planCourses) {
        this.planCourses = planCourses;
    }

    public List<ShareCourseGroup> getChildren() {
        return this.children;
    }

    public void setChildren(List<ShareCourseGroup> children) {
        this.children = children;
    }

    public SharePlan getPlan() {
        return this.plan;
    }

    public void setPlan(SharePlan plan) {
        this.plan = plan;
    }

    public ShareCourseGroup getParent() {
        return this.parent;
    }

    public void setParent(ShareCourseGroup parent) {
        this.parent = parent;
    }

    public void addPlanCourses(List<SharePlanCourse> givenPlanCourses) {
        for (SharePlanCourse element : givenPlanCourses) {
            boolean finded = false;
            for (SharePlanCourse element2 : this.planCourses) {
                if (!((Long)element.getCourse().getId()).equals(element2.getCourse().getId())) continue;
                finded = true;
                break;
            }
            if (finded) continue;
            element.setGroup(this);
            this.planCourses.add(element);
        }
    }

    public void updateCoursePlan(SharePlan plan) {
        this.setPlan(plan);
        if (this.getChildren() != null) {
            for (ShareCourseGroup group : this.getChildren()) {
                group.updateCoursePlan(plan);
            }
        }
    }

    public List<SharePlanCourse> getPlanCourses() {
        return this.planCourses;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public CourseAbilityRate getAbilityRate() {
        return this.abilityRate;
    }

    public void setAbilityRate(CourseAbilityRate abilityRate) {
        this.abilityRate = abilityRate;
    }
}

