/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.time;

import org.openurp.base.time.ContinueRange;
import org.openurp.base.time.Skip1Range;

public abstract class NumberRange {
    protected final Integer start;
    protected Integer end;
    protected Integer lastEnd;
    protected boolean abandon = false;
    protected String i18nKey;

    public static NumberRange newInstance(int number) {
        return new ContinueRange(number);
    }

    protected NumberRange(int number) {
        this.start = number;
        this.end = number;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public boolean isAbandon() {
        return this.abandon;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public boolean test(int number) {
        boolean result = this.internalTest(number);
        if (result && !this.end.equals(number)) {
            this.lastEnd = this.end;
            this.end = number;
        }
        return result;
    }

    protected abstract boolean internalTest(int var1);

    public NumberRange guessNextPattern(int number) {
        if (this.getClass().equals(Skip1Range.class)) {
            return NumberRange.newInstance(number);
        }
        if (!this.end.equals(this.start)) {
            return NumberRange.newInstance(number);
        }
        Skip1Range mayBePattern = null;
        mayBePattern = this.end % 2 == 0 ? new Skip1Range(this.end, "number.range.even") : new Skip1Range(this.end, "number.range.odd");
        if (mayBePattern.test(number)) {
            if (this.lastEnd == null) {
                this.abandon = true;
            }
            this.end = this.lastEnd;
            return mayBePattern;
        }
        return NumberRange.newInstance(number);
    }
}

