/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.model.Person;
import org.openurp.base.model.TemporalEntity;
import org.openurp.base.model.User;
import org.openurp.code.edu.model.StudyType;
import org.openurp.code.person.model.Gender;
import org.openurp.edu.base.code.model.StdLabel;
import org.openurp.edu.base.code.model.StdLabelType;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.base.model.Direction;
import org.openurp.edu.base.model.EduLevelBasedObject;
import org.openurp.edu.base.model.Major;
import org.openurp.edu.base.model.Squad;
import org.openurp.edu.base.model.StudentState;
import org.openurp.edu.base.model.Teacher;
import org.springframework.util.CollectionUtils;

@Entity(name="org.openurp.edu.base.model.Student")
public class Student
extends EduLevelBasedObject<Long>
implements TemporalEntity {
    private static final long serialVersionUID = -1973115982366299767L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected User user;
    @ManyToOne(fetch=FetchType.LAZY)
    protected Person person;
    @ManyToOne(fetch=FetchType.LAZY)
    protected StdType stdType;
    @ManyToOne(fetch=FetchType.LAZY)
    protected StudentState state;
    @OneToMany(mappedBy="std", cascade={CascadeType.ALL}, orphanRemoval=true)
    protected Set<StudentState> states = CollectUtils.newHashSet();
    @ManyToMany
    @MapKeyJoinColumn(name="std_label_type_id")
    protected Map<StdLabelType, StdLabel> labels = CollectUtils.newHashMap();
    @NotNull
    protected Float duration;
    @NotNull
    protected boolean registed;
    @NotNull
    protected Date beginOn;
    @NotNull
    protected Date endOn;
    @NotNull
    protected Date studyOn;
    @NotNull
    protected Date graduateOn;
    @ManyToOne(fetch=FetchType.LAZY)
    protected StudyType studyType;
    @ManyToOne(fetch=FetchType.LAZY)
    protected Teacher tutor;
    @Size(max=2000)
    protected String remark;

    public Student() {
    }

    public Student(Long id) {
        this.setId(id);
    }

    public Squad getSquad() {
        return this.state.getSquad();
    }

    public Department getDepartment() {
        return this.state.getDepartment();
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public Gender getGender() {
        return this.person.getGender();
    }

    public String getGrade() {
        return this.state.getGrade();
    }

    public Major getMajor() {
        return this.state.getMajor();
    }

    public Direction getDirection() {
        return this.state.getDirection();
    }

    public String getName() {
        return this.user.getName();
    }

    public String getCode() {
        return this.user.getCode();
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Campus getCampus() {
        return this.state.getCampus();
    }

    @Override
    public Date getBeginOn() {
        return this.beginOn;
    }

    @Override
    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public StudyType getStudyType() {
        return this.studyType;
    }

    public void setStudyType(StudyType studyType) {
        this.studyType = studyType;
    }

    @Override
    public Date getEndOn() {
        return this.endOn;
    }

    @Override
    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public StdType getStdType() {
        return this.stdType;
    }

    public void setStdType(StdType type) {
        this.stdType = type;
    }

    public void addLabel(StdLabel label) {
        if (null == this.labels) {
            this.labels = CollectUtils.newHashMap();
        }
        this.labels.put(label.getLabelType(), label);
    }

    public void addLabels(StdLabel ... labels) {
        if (null != labels) {
            for (StdLabel label : labels) {
                this.addLabel(label);
            }
        }
    }

    public void clearLabels() {
        if (null != this.labels) {
            this.labels.clear();
        }
    }

    public Map<StdLabelType, StdLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<StdLabelType, StdLabel> labels) {
        this.labels = labels;
    }

    public StudentState getState() {
        return this.state;
    }

    public void setState(StudentState state) {
        this.state = state;
    }

    public void pointCurrentState() throws Exception {
        if (CollectionUtils.isEmpty(this.states)) {
            throw new IllegalArgumentException("states is empty!!!");
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        long now = Long.valueOf(f.format(new Date(System.currentTimeMillis())));
        Date nowDate = new Date(System.currentTimeMillis());
        long distance = Long.MAX_VALUE;
        StudentState last = null;
        for (StudentState state : this.states) {
            if (nowDate.getTime() >= state.getBeginOn().getTime() && nowDate.getTime() <= state.getEndOn().getTime()) {
                last = state;
                break;
            }
            long middle = (Long.valueOf(f.format(state.getEndOn())) + Long.valueOf(f.format(state.getBeginOn()))) / 2L;
            long d = Math.abs(now - middle);
            if (d >= distance) continue;
            distance = d;
            last = state;
        }
        this.state = last;
    }

    public void addState(StudentState state) {
        if (null == this.states) {
            this.states = CollectUtils.newHashSet();
        }
        state.setStd(this);
        this.states.add(state);
    }

    public Set<StudentState> getStates() {
        return this.states;
    }

    public void setStates(Set<StudentState> states) {
        this.states = states;
    }

    public boolean isRegisted() {
        return this.registed;
    }

    public void setRegisted(boolean registed) {
        this.registed = registed;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Teacher getTutor() {
        return this.tutor;
    }

    public void setTutor(Teacher tutor) {
        this.tutor = tutor;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getStudyOn() {
        return this.studyOn;
    }

    public void setStudyOn(Date studyOn) {
        this.studyOn = studyOn;
    }

    public Date getGraduateOn() {
        return this.graduateOn;
    }

    public void setGraduateOn(Date graduateOn) {
        this.graduateOn = graduateOn;
    }
}

