/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.model;

import java.sql.Date;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.commons.lang.time.WeekTimes;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.edu.model.Classroom;
import org.openurp.base.edu.model.Teacher;
import org.openurp.edu.clazz.model.Clazz;

@Entity(name="org.openurp.edu.clazz.model.Session")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class Session
extends LongIdObject
implements Comparable<Session> {
    private static final long serialVersionUID = 2498530728105897805L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Clazz clazz;
    @Embedded
    protected WeekTime time;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<Teacher> teachers = CollectUtils.newHashSet();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<Classroom> rooms = CollectUtils.newHashSet();
    @Size(max=500)
    private String remark;

    public Session() {
    }

    public Date getFirstActivityTime() {
        if (null != this.time) {
            return this.time.getFirstDay();
        }
        return null;
    }

    public Date getLastActivityTime() {
        if (null != this.time) {
            return this.time.getLastDay();
        }
        return null;
    }

    public Session(Teacher teacher, Classroom room, WeekTime time) {
        if (teacher != null) {
            this.getTeachers().add(teacher);
        }
        this.getRooms().add(room);
        this.setTime(new WeekTime(time));
    }

    public Object clone() {
        Session session = new Session();
        session.getRooms().addAll(this.getRooms());
        session.setTime(new WeekTime(this.getTime()));
        session.setClazz(this.clazz);
        session.getTeachers().addAll(this.getTeachers());
        return session;
    }

    public boolean canMergerWith(Session session) {
        if (!this.getTeachers().equals(session.getTeachers())) {
            return false;
        }
        if (!this.getRooms().equals(session.getRooms())) {
            return false;
        }
        if (this.getRemark() != null && session.getRemark() != null && !this.getRemark().equals(session.getRemark()) || this.getRemark() == null && session.getRemark() != null || session.getRemark() == null && this.getRemark() != null) {
            return false;
        }
        return WeekTimes.canMergerWith(this.getTime(), session.getTime());
    }

    public void mergeWith(Session other) {
        WeekTimes.mergeWith(this.getTime(), other.getTime());
    }

    public static List<Session> mergeActivites(List<Session> tobeMerged) {
        List mergedActivityList = CollectUtils.newArrayList();
        if (CollectUtils.isEmpty(tobeMerged)) {
            return mergedActivityList;
        }
        Collections.sort(tobeMerged);
        Iterator<Session> activityIter = tobeMerged.iterator();
        Session toMerged = activityIter.next();
        mergedActivityList.add(toMerged);
        while (activityIter.hasNext()) {
            Session session = activityIter.next();
            if (toMerged.canMergerWith(session)) {
                toMerged.mergeWith(session);
                continue;
            }
            toMerged = session;
            mergedActivityList.add(toMerged);
        }
        return mergedActivityList;
    }

    @Override
    public int compareTo(Session session) {
        int rs = 0;
        if (rs == 0) {
            rs = this.getTeachers().size() - session.getTeachers().size();
        }
        if (rs == 0) {
            rs = this.getRooms().size() - session.getRooms().size();
        }
        if (rs == 0) {
            rs = this.getTime().getWeekstate().compareTo(session.getTime().getWeekstate());
        }
        if (rs == 0) {
            rs = this.getTime().getStartOn().compareTo(session.getTime().getStartOn());
        }
        if (rs == 0) {
            rs = this.getTime().getBeginAt().value - session.getTime().getBeginAt().value;
        }
        return rs;
    }

    public String toString() {
        return Objects.toStringBuilder((Object)this).add("rooms", this.getRooms()).add("time", (Object)this.getTime()).add("teachers", this.getTeachers()).add("id", (Object)this.id).toString();
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public Set<Teacher> getTeachers() {
        return this.teachers;
    }

    public void setTeachers(Set<Teacher> teachers) {
        this.teachers = teachers;
    }

    public Set<Classroom> getRooms() {
        return this.rooms;
    }

    public void setRooms(Set<Classroom> rooms) {
        this.rooms = rooms;
    }

    public WeekTime getTime() {
        return this.time;
    }

    public void setTime(WeekTime time) {
        this.time = time;
    }

    public java.util.Date getBeginAt() {
        if (null != this.time) {
            return this.time.getFirstDay();
        }
        return null;
    }

    public java.util.Date getEndAt() {
        return null;
    }

    public boolean contains(java.util.Date oneDay) {
        return false;
    }

    public String getContent() {
        return this.clazz.getCrn();
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

