/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Size;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Range;
import org.openurp.edu.grade.course.model.GradeRateConfig;

@Entity(name="org.openurp.edu.grade.course.model.GradeRateItem")
public class GradeRateItem
extends LongIdObject {
    private static final long serialVersionUID = 0L;
    @ManyToOne(fetch=FetchType.LAZY)
    private GradeRateConfig config;
    private String grade;
    private Float minScore;
    private Float maxScore;
    @Size(max=255)
    private String gpExp;
    private Float defaultScore;

    public boolean contains(Float f) {
        return Range.between((Comparable)this.minScore, (Comparable)this.maxScore).contains((Object)Float.valueOf(f.floatValue()));
    }

    public boolean inScope(Float score) {
        return this.maxScore.compareTo(score) > -1 && this.minScore.compareTo(score) < 1;
    }

    public GradeRateConfig getConfig() {
        return this.config;
    }

    public void setConfig(GradeRateConfig config) {
        this.config = config;
    }

    public Float getMinScore() {
        return this.minScore;
    }

    public void setMinScore(Float minScore) {
        this.minScore = minScore;
    }

    public Float getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(Float maxScore) {
        this.maxScore = maxScore;
    }

    public Float getDefaultScore() {
        return this.defaultScore;
    }

    public void setDefaultScore(Float defaultScore) {
        this.defaultScore = defaultScore;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public String getGpExp() {
        return this.gpExp;
    }

    public void setGpExp(String gpExp) {
        this.gpExp = gpExp;
    }
}

