/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.model;

import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.edu.model.Student;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.edu.grade.course.model.StdSemesterGpa;
import org.openurp.edu.grade.course.model.StdYearGpa;

@Entity(name="org.openurp.edu.grade.course.model.StdGpa")
public class StdGpa
extends NumberIdTimeObject<Long> {
    private static final long serialVersionUID = -5674629758471007484L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Student std;
    @OneToMany(mappedBy="stdGpa", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<StdSemesterGpa> semesterGpas;
    @OneToMany(mappedBy="stdGpa", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<StdYearGpa> yearGpas;
    private Float gpa;
    private Float ga;
    private Float credits;
    private Float totalCredits;
    private int gradeCount;
    private transient Map<Semester, StdSemesterGpa> semesterGpaCache;
    private transient Map<String, StdYearGpa> yearGpaCache;

    public StdGpa() {
    }

    public StdGpa(Long id) {
        super(id);
    }

    public StdGpa(Student std) {
        this.std = std;
        this.project = std.getProject();
        this.semesterGpas = CollectUtils.newArrayList();
        this.yearGpas = CollectUtils.newArrayList();
        this.credits = Float.valueOf(0.0f);
        this.gradeCount = 0;
        this.ga = new Float(0.0f);
        this.gpa = new Float(0.0f);
    }

    public Float getGpa(Semester semester) {
        StdSemesterGpa gpterm = this.getStdTermGpa(semester);
        if (null == gpterm) {
            return null;
        }
        return gpterm.getGpa();
    }

    public StdSemesterGpa getStdTermGpa(Semester semester) {
        if (null == this.semesterGpaCache || this.semesterGpaCache.size() != this.semesterGpas.size()) {
            this.semesterGpaCache = CollectUtils.newHashMap();
            for (StdSemesterGpa gpterm : this.getSemesterGpas()) {
                this.semesterGpaCache.put(gpterm.getSemester(), gpterm);
            }
        }
        return this.semesterGpaCache.get(semester);
    }

    public StdYearGpa getYearGpa(String schoolYear) {
        if (null == this.yearGpaCache || this.yearGpaCache.size() != this.yearGpas.size()) {
            this.yearGpaCache = CollectUtils.newHashMap();
            for (StdYearGpa gpYear : this.getYearGpas()) {
                this.yearGpaCache.put(gpYear.getSchoolYear(), gpYear);
            }
        }
        return this.yearGpaCache.get(schoolYear);
    }

    public void add(StdSemesterGpa stdTermGpa) {
        if (null == this.semesterGpas) {
            this.semesterGpas = CollectUtils.newArrayList();
        }
        stdTermGpa.setStdGpa(this);
        this.semesterGpas.add(stdTermGpa);
    }

    public void add(StdYearGpa stdYearGpa) {
        if (null == this.yearGpas) {
            this.yearGpas = CollectUtils.newArrayList();
        }
        stdYearGpa.setStdGpa(this);
        this.yearGpas.add(stdYearGpa);
    }

    public List<StdSemesterGpa> getSemesterGpas() {
        return this.semesterGpas;
    }

    public void setSemesterGpas(List<StdSemesterGpa> semesterGpas) {
        this.semesterGpas = semesterGpas;
    }

    public List<StdYearGpa> getYearGpas() {
        return this.yearGpas;
    }

    public void setYearGpas(List<StdYearGpa> yearGpas) {
        this.yearGpas = yearGpas;
    }

    public Student getStd() {
        return this.std;
    }

    public void setStd(Student student) {
        this.std = student;
    }

    public Float getGpa() {
        return this.gpa;
    }

    public void setGpa(Float gpa) {
        this.gpa = gpa;
    }

    public int getGradeCount() {
        return this.gradeCount;
    }

    public void setGradeCount(int gradeCount) {
        this.gradeCount = gradeCount;
    }

    public Float getCredits() {
        return this.credits;
    }

    public void setCredits(Float credits) {
        this.credits = credits;
    }

    public Float getGa() {
        return this.ga;
    }

    public void setGa(Float ga) {
        this.ga = ga;
    }

    public Float getTotalCredits() {
        return this.totalCredits;
    }

    public void setTotalCredits(Float totalCredits) {
        this.totalCredits = totalCredits;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

