/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.edu.model;

import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.NumberIdObject;
import org.beangle.commons.lang.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.NaturalId;
import org.openurp.base.edu.model.Calendar;
import org.openurp.base.edu.model.SemesterStage;

@Entity(name="org.openurp.base.edu.model.Semester")
@Cacheable
@Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Semester
extends NumberIdObject<Integer>
implements Comparable<Semester> {
    private static final long serialVersionUID = 1418209086970834483L;
    @NotNull
    @NaturalId(mutable=true)
    @Size(max=32)
    private String code;
    @NotNull
    @Size(max=50)
    private String schoolYear;
    @NotNull
    @Size(max=100)
    private String name;
    @NotNull
    private Date beginOn;
    @NotNull
    private Date endOn;
    @NotNull
    @NaturalId(mutable=true)
    @ManyToOne(fetch=FetchType.LAZY)
    private Calendar calendar;
    @Size(max=200)
    private String remark;
    @OneToMany(mappedBy="semester", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    private List<SemesterStage> stages;

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Semester() {
    }

    public Semester(Integer id) {
        this.id = id;
    }

    public Semester(String schoolYear, String name, Date beginOn, Date endOn) {
        this.schoolYear = schoolYear;
        this.name = name;
        this.beginOn = beginOn;
        this.endOn = endOn;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean before(Semester semester) {
        return this.endOn.before(semester.getBeginOn());
    }

    public boolean after(Semester semester) {
        return this.beginOn.after(semester.getEndOn());
    }

    public boolean contains(java.util.Date date) {
        return !date.before(this.getBeginOn()) && !date.after(this.getEndOn());
    }

    public String getSchoolYear() {
        return this.schoolYear;
    }

    public void setSchoolYear(String schoolYear) {
        this.schoolYear = schoolYear;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public boolean isShorter() {
        return this.getWeeks() <= 8;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public int getStartYear() {
        if (null != this.getBeginOn()) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(this.getBeginOn());
            return gc.get(1);
        }
        return 0;
    }

    public int getStartWeek() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setFirstDayOfWeek(this.calendar.getFirstWeekday().getIndex());
        gc.setTime(this.getBeginOn());
        return gc.get(3);
    }

    public int getWeeks() {
        long length = this.getEndOn().getTime() - this.getBeginOn().getTime();
        return (int)Math.ceil((double)length / 6.048E8);
    }

    public List<List<java.util.Date>> getWeekDates() {
        List dates = CollectUtils.newArrayList();
        GregorianCalendar start = new GregorianCalendar();
        start.setTime(this.getBeginOn());
        Date finish = this.getEndOn();
        List weekDates = null;
        int firstWeekDayIndex = this.calendar.getFirstWeekday().getIndex();
        while (start.get(7) != firstWeekDayIndex) {
            ((java.util.Calendar)start).add(6, -1);
        }
        int i = 0;
        while (!start.getTime().after(finish)) {
            if (i == 0) {
                weekDates = CollectUtils.newArrayList();
                dates.add(weekDates);
            }
            weekDates.add(start.getTime());
            ++i;
            i %= 7;
            ((java.util.Calendar)start).add(6, 1);
        }
        if (start.get(7) == firstWeekDayIndex) {
            ((java.util.Calendar)start).add(6, 1);
            weekDates.add(start.getTime());
        }
        while (start.get(7) != firstWeekDayIndex) {
            ((java.util.Calendar)start).add(6, 1);
            weekDates.add(start.getTime());
        }
        return dates;
    }

    public String toString() {
        return Objects.toStringBuilder((Object)this).add("schoolYear", (Object)this.schoolYear).add("name", (Object)this.name).add("beginOn", (Object)this.getBeginOn()).add("endOn", (Object)this.getEndOn()).toString();
    }

    @Override
    public int compareTo(Semester other) {
        return Objects.compareBuilder().add((Object)this.schoolYear, (Object)other.getSchoolYear()).add((Object)this.beginOn, (Object)other.getBeginOn()).toComparison();
    }

    public boolean isArchived() {
        return false;
    }

    public List<SemesterStage> getStages() {
        return this.stages;
    }

    public void setStages(List<SemesterStage> stages) {
        this.stages = stages;
    }
}

