/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.model.User;
import org.openurp.edu.exam.model.InvigilationQuotaDetail;

@Entity(name="org.openurp.edu.exam.model.InvigilationQuota")
public class InvigilationQuota
extends LongIdObject {
    private static final long serialVersionUID = -2403939113974261022L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private User invigilator;
    private int amount;
    @OneToMany(mappedBy="quota", cascade={CascadeType.ALL})
    private List<InvigilationQuotaDetail> details = new ArrayList<InvigilationQuotaDetail>();
    @ElementCollection
    @JoinColumn(name="invigilation_quota_id")
    @Column(name="exclude_on", nullable=false)
    @JoinTable(name="invigilation_quotas_excludes")
    private List<Date> excludes;
    @Size(max=200)
    private String remark;

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public List<Date> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<Date> excludes) {
        this.excludes = excludes;
    }

    public List<InvigilationQuotaDetail> getDetails() {
        return this.details;
    }

    public void setDetails(List<InvigilationQuotaDetail> details) {
        this.details = details;
    }

    public User getInvigilator() {
        return this.invigilator;
    }

    public void setInvigilator(User invigilator) {
        this.invigilator = invigilator;
    }

    public InvigilationQuotaDetail addQuota(Campus campus, Department depart, float amount) {
        InvigilationQuotaDetail finded = null;
        for (InvigilationQuotaDetail iq : this.details) {
            if (!iq.getCampus().equals(campus) || !iq.getDepart().equals(depart)) continue;
            iq.setAmount(iq.getAmount() + amount);
            finded = iq;
            break;
        }
        if (null == finded) {
            finded = new InvigilationQuotaDetail(campus, depart, amount);
            finded.setQuota(this);
            this.getDetails().add(finded);
        }
        double sum = 0.0;
        for (InvigilationQuotaDetail iq : this.details) {
            sum += (double)iq.getAmount();
        }
        this.amount = Double.valueOf(Math.round(sum)).intValue();
        return finded;
    }

    public void clearQuota() {
        this.amount = 0;
        for (InvigilationQuotaDetail iq : this.details) {
            iq.setAmount(0.0f);
        }
    }

    public boolean cleanup() {
        List removed = CollectUtils.newArrayList();
        double sum = 0.0;
        for (InvigilationQuotaDetail iq : this.details) {
            if (Float.compare(0.0f, iq.getAmount()) == 0) {
                removed.add(iq);
            }
            iq.setAmount(Double.valueOf(Math.round(iq.getAmount())).intValue());
            sum += (double)iq.getAmount();
        }
        this.setAmount(Double.valueOf(sum).intValue());
        return this.details.removeAll(removed);
    }

    public Set<Department> getDeparts() {
        Set departs = CollectUtils.newHashSet();
        for (InvigilationQuotaDetail iq : this.details) {
            departs.add(iq.getDepart());
        }
        return departs;
    }

    public Set<Campus> getCampuses() {
        Set cs = CollectUtils.newHashSet();
        for (InvigilationQuotaDetail iq : this.details) {
            cs.add(iq.getCampus());
        }
        return cs;
    }

    public int getCampusQuota(Campus campus) {
        double sum = 0.0;
        for (InvigilationQuotaDetail iq : this.details) {
            if (!iq.getCampus().equals(campus)) continue;
            sum += (double)iq.getAmount();
        }
        return Double.valueOf(sum).intValue();
    }
}

