/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.model;

import java.text.NumberFormat;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.NaturalId;
import org.openurp.base.edu.model.Project;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.grade.course.model.GradeRateItem;

@Entity(name="org.openurp.edu.grade.course.model.GradeRateConfig")
public class GradeRateConfig
extends LongIdObject {
    private static final long serialVersionUID = 7557740151486177737L;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private GradingMode gradingMode;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @OneToMany(mappedBy="config", orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderBy(value="maxScore desc")
    private List<GradeRateItem> items;
    private float passScore;

    public float getPassScore() {
        return this.passScore;
    }

    public void setPassScore(float passScore) {
        this.passScore = passScore;
    }

    public String convert(Float score) {
        if (null == score) {
            return "";
        }
        if (this.gradingMode.isNumerical()) {
            return NumberFormat.getInstance().format(score.floatValue());
        }
        for (GradeRateItem item : this.items) {
            if (!item.contains(score)) continue;
            return item.getGrade();
        }
        return "";
    }

    public String toString() {
        return "GradeRateConfig [gradingMode=" + this.gradingMode + ", project=" + this.project + ", items=" + this.items + ", passScore=" + this.passScore + "]";
    }

    public List<GradeRateItem> getItems() {
        return this.items;
    }

    public void setItems(List<GradeRateItem> items) {
        this.items = items;
    }

    public final Project getProject() {
        return this.project;
    }

    public final void setProject(Project project) {
        this.project = project;
    }

    public GradingMode getGradingMode() {
        return this.gradingMode;
    }

    public void setGradingMode(GradingMode gradingMode) {
        this.gradingMode = gradingMode;
    }
}

