/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.web.util.HttpUtils;
import org.openurp.app.Ems;
import org.openurp.app.EmsApp;
import org.openurp.app.util.AesEncryptor;
import org.openurp.app.util.DataSourceUtils;
import org.openurp.app.util.DatasourceConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class AppDataSourceFactory
implements FactoryBean<DataSource>,
InitializingBean,
DisposableBean {
    private String url;
    private String user;
    private String password;
    private String driver;
    private String name;
    private Map<String, String> props = new HashMap<String, String>();
    private DataSource _result;

    public DataSource getObject() {
        return this._result;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public void destroy() {
        DataSourceUtils.close(this._result);
    }

    public boolean isSingleton() {
        return true;
    }

    public void fetchConf() {
        File appFile;
        if (null == this.name) {
            this.name = "default";
        }
        this.url = (appFile = EmsApp.getAppFile()).exists() ? EmsApp.getAppFile().getAbsolutePath() : Ems.getInstance().getApi() + "/platform/config/datasources/" + EmsApp.getName() + "/" + this.name + ".json?secret=" + EmsApp.Instance.getSecret();
        try {
            this.postInit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.fetchConf();
        this._result = DataSourceUtils.build(this.driver, this.user, this.password, this.props);
    }

    public void postInit() throws Exception {
        if (null != this.url) {
            boolean isXML = this.url.endsWith(".xml");
            if (this.url.startsWith("jdbc:")) {
                if (null == this.driver) {
                    this.driver = Strings.substringBetween((String)this.url, (String)"jdbc:", (String)":");
                    this.props.put("url", this.url);
                }
            } else if (this.url.startsWith("http")) {
                String text = HttpUtils.getResponseText((String)this.url);
                if (Strings.isNotBlank((CharSequence)text)) {
                    ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
                    this.merge(AppDataSourceFactory.readConf(is, this.name, isXML));
                }
            } else {
                File f = new File(this.url);
                URL urlAddr = f.exists() ? f.toURI().toURL() : new URL(this.url);
                this.merge(AppDataSourceFactory.readConf(urlAddr.openStream(), this.name, isXML));
            }
        }
        if (this.password != null && this.password.startsWith("?")) {
            this.password = new AesEncryptor(Ems.Instance.getKey()).decrypt(this.password.substring(1));
        }
    }

    public static DatasourceConfig readConf(InputStream is, String dsname, boolean isXML) {
        DatasourceConfig conf = null;
        conf = isXML ? DataSourceUtils.parseXml(is, dsname) : DataSourceUtils.parseJson(is);
        return conf;
    }

    private void merge(DatasourceConfig conf) {
        if (null == this.user) {
            this.user = conf.user;
        }
        if (null == this.password) {
            this.password = conf.password;
        }
        if (null == this.driver) {
            this.driver = conf.driver;
        }
        if (null == this.name) {
            this.name = conf.name;
        }
        for (Map.Entry<String, String> e : conf.props.entrySet()) {
            if (this.props.containsKey(e.getKey())) continue;
            this.props.put(e.getKey(), e.getValue());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }
}

