/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.edu.model;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beangle.commons.bean.comparators.PropertyComparator;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.time.HourMinute;
import org.beangle.commons.lang.time.WeekDay;
import org.beangle.commons.lang.time.WeekState;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.commons.lang.time.Weeks;
import org.beangle.commons.lang.tuple.Pair;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.time.NumberRangeDigestor;
import org.openurp.base.time.NumberSequence;

public class WeekTimeBuilder {
    private final LocalDate startOn;
    private final LocalDate firstWeekEndOn;

    private WeekTimeBuilder(LocalDate startOn, WeekDay firstDay) {
        this.startOn = startOn;
        LocalDate endOn = startOn;
        WeekDay weekendDay = firstDay.previous();
        while (endOn.getDayOfWeek().getValue() != ((Integer)weekendDay.getId()).intValue()) {
            endOn = endOn.plusDays(1L);
        }
        this.firstWeekEndOn = endOn;
    }

    public static WeekTimeBuilder on(Semester semester) {
        return new WeekTimeBuilder(semester.getBeginOn().toLocalDate(), semester.getCalendar().getFirstWeekday());
    }

    public static String digestWeekTime(WeekTime time, Semester semester) {
        if (null == time) {
            return "";
        }
        LocalDate beginOn = semester.getBeginOn().toLocalDate();
        int firstWeekday = beginOn.getDayOfWeek().getValue();
        LocalDate timeBeginOn = time.getStartOn().toLocalDate();
        while (timeBeginOn.getDayOfWeek().getValue() != firstWeekday) {
            timeBeginOn = timeBeginOn.plusDays(-1L);
        }
        int weeksDistance = Weeks.between(beginOn, timeBeginOn);
        long weekstate = time.getWeekstate().getValue();
        weekstate = weeksDistance < 0 ? (weekstate >>= 0 - weeksDistance) : (weekstate <<= weeksDistance);
        Integer[] weekIndecies = new WeekState(weekstate).getWeekList().toArray(new Integer[0]);
        String digest = NumberRangeDigestor.digest(weekIndecies, null);
        return digest.replace("[", "").replace("]", "").replace("number.range.odd", "\u5355").replace("number.range.even", "\u53cc");
    }

    public static List<WeekTime> build(Date beginOn, Date endOn) {
        Map timeMap = CollectUtils.newHashMap();
        Calendar c = Calendar.getInstance();
        Calendar e = Calendar.getInstance();
        e.setTime(endOn);
        c.setTime(beginOn);
        while (!c.after(e)) {
            WeekTime t = WeekTime.of(new Date(c.getTime().getTime()));
            WeekTime existed = (WeekTime)timeMap.get(t.getStartOn());
            if (null == existed) {
                timeMap.put(t.getStartOn(), t);
            } else {
                existed.setWeekstate(existed.getWeekstate().bitor(t.getWeekstate()));
            }
            c.add(6, 1);
        }
        List times = CollectUtils.newArrayList(timeMap.values());
        Collections.sort(times, new PropertyComparator("startOn"));
        return times;
    }

    public List<WeekTime> buildOnOldWeekStr(WeekDay weekday, String weekstr) {
        ArrayList<Integer> weekList = new ArrayList<Integer>();
        for (int i = 0; i < weekstr.length(); ++i) {
            if (weekstr.charAt(i) != '1') continue;
            weekList.add(i);
        }
        int[] weeks = new int[weekList.size()];
        for (int i = 0; i < weekList.size(); ++i) {
            weeks[i] = (Integer)weekList.get(i);
        }
        return this.build(weekday, weeks);
    }

    public static boolean needNormalize(WeekTime wt) {
        Date lastDay;
        int startYear = wt.getStartYear();
        return startYear != (lastDay = wt.getLastDay()).getYear() + 1900;
    }

    public static WeekTime normalize(WeekTime wt) {
        int startYear = wt.getStartYear();
        Date lastDay = wt.getLastDay();
        WeekTime nextWt = null;
        while (startYear != lastDay.getYear() + 1900) {
            if (null == nextWt) {
                nextWt = new WeekTime();
                nextWt.setBeginAt(wt.getBeginAt());
                nextWt.setEndAt(wt.getEndAt());
                nextWt.setStartOn(Date.valueOf(WeekTime.getStartOn(lastDay.getYear() + 1900, wt.getWeekday())));
                nextWt.setWeekstate(WeekState.Zero);
            }
            wt.dropDay(lastDay);
            nextWt.addDay(lastDay);
            lastDay = wt.getLastDay();
        }
        return nextWt;
    }

    public static int getOffset(Semester semester, WeekDay weekday) {
        LocalDate startOn = semester.getBeginOn().toLocalDate();
        while (startOn.getDayOfWeek().getValue() != ((Integer)weekday.getId()).intValue()) {
            startOn = startOn.plusDays(1L);
        }
        LocalDate yearStartOn = WeekTime.getStartOn(startOn.getYear(), weekday);
        return Weeks.between(yearStartOn, startOn);
    }

    public static int getReverseOffset(Semester semester, WeekDay weekday) {
        LocalDate startOn = semester.getBeginOn().toLocalDate();
        while (startOn.getDayOfWeek().getValue() != ((Integer)weekday.getId()).intValue()) {
            startOn = startOn.plusDays(1L);
        }
        LocalDate yearStartOn = WeekTime.getStartOn(startOn.getYear() + 1, weekday);
        return Math.abs(Weeks.between(yearStartOn, startOn));
    }

    public List<WeekTime> build(WeekDay weekday, Collection<Integer> weeks) {
        int[] weekIndices = new int[weeks.size()];
        int i = 0;
        for (Integer w : weeks) {
            weekIndices[i] = w;
            ++i;
        }
        return this.build(weekday, weekIndices);
    }

    public List<WeekTime> build(WeekDay weekday, int[] weeks) {
        HashMap<Integer, WeekTime> times = new HashMap<Integer, WeekTime>();
        LocalDate startDate = this.startOn;
        while (startDate.getDayOfWeek().getValue() != ((Integer)weekday.getId()).intValue()) {
            startDate = startDate.plusDays(1L);
        }
        int minWeek = 1;
        if (startDate.isAfter(this.firstWeekEndOn)) {
            minWeek = 2;
        }
        for (int week : weeks) {
            if (week < minWeek) continue;
            LocalDate oneday = startDate.plusWeeks(week - 1);
            int year = oneday.getYear();
            WeekTime weektime = (WeekTime)times.get(year);
            LocalDate yearStartOn = WeekTime.getStartOn(year, weekday);
            if (null == weektime) {
                weektime = new WeekTime();
                times.put(year, weektime);
                weektime.setStartOn(Date.valueOf(yearStartOn));
                weektime.setWeekstate(new WeekState(0L));
            }
            weektime.setWeekstate(new WeekState(weektime.getWeekstate().value | WeekState.of((int)(Weeks.between((LocalDate)yearStartOn, (LocalDate)oneday) + 1)).value));
        }
        return new ArrayList<WeekTime>(times.values());
    }

    public static List<Date> getYearStartOns(Semester semester, WeekDay weekday) {
        int year = semester.getStartYear();
        List dates = CollectUtils.newArrayList();
        dates.add(Date.valueOf(WeekTime.getStartOn(year, weekday)));
        dates.add(Date.valueOf(WeekTime.getStartOn(year, weekday)));
        return dates;
    }

    public static Date getStartOn(Semester semester, WeekDay weekday) {
        LocalDate ld = semester.getBeginOn().toLocalDate();
        while (ld.getDayOfWeek().getValue() != ((Integer)weekday.getId()).intValue()) {
            ld = ld.plusDays(1L);
        }
        return Date.valueOf(ld);
    }

    public static WeekTime of(int startWeek, int endWeek, NumberSequence.Pattern pattern) {
        int[] range = NumberSequence.build(startWeek, endWeek, pattern);
        WeekTime courseTime = new WeekTime();
        courseTime.setWeekstate(WeekState.of(range));
        return courseTime;
    }

    public static WeekTime of(Date startOn, HourMinute beginAt, HourMinute endAt) {
        WeekTime time = WeekTime.of(startOn);
        time.setBeginAt(beginAt);
        time.setEndAt(endAt);
        return time;
    }

    public static Pair<Date, Date> getDateRange(Semester semester, int weekIndex) {
        Date beginOn = WeekTimeBuilder.on(semester).build(semester.getCalendar().getFirstWeekday(), new int[]{weekIndex}).get(0).getFirstDay();
        LocalDate ld = beginOn.toLocalDate();
        ld = ld.plusDays(6L);
        return Pair.of((Object)beginOn, (Object)Date.valueOf(ld));
    }

    public static Date getDate(Semester semester, int teachWeek, WeekDay weekday) {
        return WeekTimeBuilder.on(semester).build(weekday, new int[]{teachWeek}).get(0).getFirstDay();
    }

    public static int weekIndexOf(Semester semester, Date oneday) {
        LocalDate beginOn = semester.getBeginOn().toLocalDate();
        int firstWeekday = beginOn.getDayOfWeek().getValue();
        LocalDate timeBeginOn = oneday.toLocalDate();
        while (timeBeginOn.getDayOfWeek().getValue() != firstWeekday) {
            timeBeginOn = timeBeginOn.plusDays(-1L);
        }
        return Weeks.between(beginOn, timeBeginOn);
    }

    public static int getStartYear(Semester semester) {
        if (null != semester.getBeginOn()) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(semester.getBeginOn());
            return gc.get(1);
        }
        return 0;
    }

    public static WeekDay[] getWeekDays(Semester semester) {
        boolean isSundayFirst = semester.getCalendar().getFirstWeekday().equals(WeekDay.Sun);
        return WeekDay.getWeekdayArray(isSundayFirst);
    }
}

