/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.edu.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OrderColumn;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.TimeEntity;
import org.beangle.commons.lang.functor.Predicate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.edu.code.model.StdLabel;
import org.openurp.base.edu.code.model.StdType;
import org.openurp.base.edu.model.Calendar;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.base.model.School;
import org.openurp.base.model.TemporalEntity;
import org.openurp.code.edu.model.EduCategory;
import org.openurp.code.edu.model.EducationLevel;

@Entity(name="org.openurp.base.edu.model.Project")
@Cacheable
@Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Project
extends NumberIdTimeObject<Integer>
implements TimeEntity,
TemporalEntity {
    private static final long serialVersionUID = 1905920232617502052L;
    public static final Predicate<Department> TEACHING = new Predicate<Department>(){

        public Boolean apply(Department depart) {
            return depart.isTeaching();
        }
    };
    @Column(unique=true)
    @NotNull
    @Size(max=100)
    private String name;
    @Column(unique=true)
    @NotNull
    @Size(max=100)
    private String code;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private School school;
    @ManyToMany
    @NotNull
    @Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<Campus> campuses = CollectUtils.newArrayList();
    @ManyToMany(targetEntity=Department.class)
    @NotNull
    @Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @OrderColumn(name="idx")
    private List<Department> departments = CollectUtils.newArrayList();
    @ManyToMany
    @NotNull
    @Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<EducationLevel> levels = CollectUtils.newArrayList();
    @ManyToMany
    @NotNull
    @Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<StdLabel> stdLabels = CollectUtils.newArrayList();
    @ManyToMany
    @NotNull
    @Cache(region="openurp.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<StdType> stdTypes = CollectUtils.newArrayList();
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Calendar calendar;
    @Size(max=500)
    private String description;
    @NotNull
    private boolean minor;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private EduCategory category;
    @NotNull
    protected Date beginOn;
    protected Date endOn;
    @ElementCollection
    @MapKeyColumn(name="name")
    @Column(name="value_", length=4000)
    private Map<String, String> properties = CollectUtils.newHashMap();

    public List<Semester> getSemesters() {
        ArrayList<Semester> semesters = new ArrayList<Semester>();
        semesters.addAll(this.calendar.getSemesters());
        return semesters;
    }

    public Project() {
    }

    public Project(Integer id) {
        this.setId(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<EducationLevel> getLevels() {
        return this.levels;
    }

    public void setLevels(List<EducationLevel> levels) {
        this.levels = levels;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public List<Department> getDepartments() {
        return this.departments;
    }

    public void setDepartments(List<Department> departments) {
        this.departments = departments;
    }

    public List<Campus> getCampuses() {
        return this.campuses;
    }

    public void setCampuses(List<Campus> campuses) {
        this.campuses = campuses;
    }

    public List<StdLabel> getStdLabels() {
        return this.stdLabels;
    }

    public void setStdLabels(List<StdLabel> labels) {
        this.stdLabels = labels;
    }

    public List<StdType> getStdTypes() {
        return this.stdTypes;
    }

    public void setStdTypes(List<StdType> types) {
        this.stdTypes = types;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMinor() {
        return this.minor;
    }

    public void setMinor(boolean minor) {
        this.minor = minor;
    }

    @Override
    public Date getBeginOn() {
        return this.beginOn;
    }

    @Override
    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    @Override
    public Date getEndOn() {
        return this.endOn;
    }

    @Override
    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public School getSchool() {
        return this.school;
    }

    public void setSchool(School school2) {
        this.school = school2;
    }

    public List<Department> getTeachingDeparts() {
        return CollectUtils.select(this.departments, TEACHING);
    }

    public List<Department> getColleges() {
        return CollectUtils.select(this.departments, TEACHING);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public EduCategory getCategory() {
        return this.category;
    }

    public void setCategory(EduCategory category) {
        this.category = category;
    }
}

