/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Type;
import org.openurp.base.edu.code.model.CourseType;
import org.openurp.base.model.AuditStatus;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.Program;

@MappedSuperclass
public abstract class AbstractCoursePlan
extends LongIdObject
implements CoursePlan {
    private static final long serialVersionUID = 1606351182470625309L;
    @NotNull
    @OneToOne(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    protected Program program;
    @NotNull
    @Type(type="org.beangle.orm.hibernate.udt.IDEnumType")
    private AuditStatus status = AuditStatus.UNSUBMITTED;
    @NotNull
    private float credits;
    private int startTerm;
    private int endTerm;
    @NotNull
    private java.sql.Date beginOn;
    @NotNull
    private java.sql.Date endOn;
    private Date updatedAt;

    @Override
    public int getStartTerm() {
        return this.startTerm;
    }

    @Override
    public void setStartTerm(int startTerm) {
        this.startTerm = startTerm;
    }

    @Override
    public int getEndTerm() {
        return this.endTerm;
    }

    @Override
    public void setEndTerm(int endTerm) {
        this.endTerm = endTerm;
    }

    @Override
    public int getTermsCount() {
        return this.endTerm - this.startTerm + 1;
    }

    @Override
    public float getCredits() {
        return this.credits;
    }

    @Override
    public void setCredits(float credits) {
        this.credits = credits;
    }

    public void addGroup(CourseGroup group) {
        if (null == this.getGroups()) {
            this.setGroups(new ArrayList());
        }
        this.getGroups().add(group);
        group.updateCoursePlan(this);
    }

    @Override
    public List<CourseGroup> getTopCourseGroups() {
        if (this.getGroups() == null) {
            return new ArrayList<CourseGroup>();
        }
        ArrayList<CourseGroup> res = new ArrayList<CourseGroup>();
        for (CourseGroup group : this.getGroups()) {
            if (group == null || group.getParent() != null) continue;
            res.add(group);
        }
        return res;
    }

    @Override
    public CourseGroup getGroup(CourseType type) {
        if (null == this.getGroups()) {
            return null;
        }
        for (CourseGroup group : this.getGroups()) {
            if (!group.getCourseType().equals((Object)type)) continue;
            return group;
        }
        return null;
    }

    public boolean isNumericTerm() {
        return true;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public AuditStatus getStatus() {
        return this.status;
    }

    public void setStatus(AuditStatus status) {
        this.status = status;
    }

    @Override
    public java.sql.Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(java.sql.Date beginOn) {
        this.beginOn = beginOn;
    }

    @Override
    public java.sql.Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(java.sql.Date endOn) {
        this.endOn = endOn;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }
}

