/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.io.IOs;
import org.beangle.commons.lang.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ems {
    private static final Logger logger = LoggerFactory.getLogger(Ems.class);
    private final String home;
    private final String base;
    private final String cas;
    private final String api;
    private final String webapp;
    private final String portal;
    private final String cdn;
    private final String key;
    private final Map<String, String> properties;
    public static Ems Instance = new Ems(Ems.findHome(), Ems.readConfig(Ems.findHome()));

    public Ems(String home, Map<String, String> properties) {
        this.home = home;
        this.properties = properties;
        logger.info("Ems Home:{}", (Object)this.home);
        if (!properties.containsKey("base")) {
            throw new RuntimeException("Cannot find base");
        }
        this.base = this.processUrl(properties.get("base"));
        this.cas = this.readBase("cas");
        this.api = this.readBase("api");
        this.webapp = this.readBase("webapp");
        this.portal = this.readBase("portal");
        this.cdn = this.readBase("static");
        this.key = properties.getOrDefault("key", "openurp");
    }

    private String processUrl(String b) {
        if (((String)b).endsWith("/")) {
            b = ((String)b).substring(0, ((String)b).length() - 1);
        }
        if (!((String)b).startsWith("http")) {
            b = "http://" + (String)b;
        }
        return b;
    }

    private String readBase(String property) {
        Object b = this.properties.get(property);
        if (null == b) {
            b = property.equals("webapp") ? this.properties.get("base") : this.properties.get("base") + "/" + property;
        }
        return this.processUrl((String)b);
    }

    public String getHome() {
        return this.home;
    }

    public String getWebappPath(String appPath) {
        return this.webapp + appPath;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getBase() {
        return this.base;
    }

    public String getApi() {
        return this.api;
    }

    public String getCas() {
        return this.cas;
    }

    public String getPortal() {
        return this.portal;
    }

    public String getCdn() {
        return this.cdn;
    }

    public String getWebapp() {
        return this.webapp;
    }

    public String getStatic() {
        return this.cdn;
    }

    public String getKey() {
        return this.key;
    }

    public static Ems getInstance() {
        return Instance;
    }

    public static String findHome() {
        Object home = System.getProperty("ems.home");
        if (home == null) {
            String profile = System.getProperty("ems.profile");
            home = null == profile ? SystemInfo.getUser().getHome() + "/.ems" : SystemInfo.getUser().getHome() + "/.ems/" + profile;
        }
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readConfig(String home) {
        Map properties;
        block5: {
            properties = CollectUtils.newHashMap();
            File f = new File(home + "/conf.properties");
            if (!f.exists()) break block5;
            Properties p = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                p.load(is);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOs.close(is);
                    throw throwable;
                }
                IOs.close((Closeable)is);
            }
            IOs.close((Closeable)is);
            for (Object k : p.keySet()) {
                properties.put(k.toString(), p.getProperty(k.toString()).toString());
            }
        }
        return properties;
    }
}

