/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.model;

import java.util.Set;
import javax.persistence.Embeddable;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Component;
import org.openurp.base.edu.model.Course;

@Embeddable
public class AuditStat
implements Component {
    private float requiredCredits;
    private float passedCredits;
    private int requiredCount;
    private int passedCount;
    private transient Set<Course> passedCourses = CollectUtils.newHashSet();
    private float convertedCredits;

    public AuditStat() {
    }

    public AuditStat(float creditCompleted, int totalNum) {
        this.passedCredits = creditCompleted;
        this.passedCount = totalNum;
    }

    public void addCredits(float credits) {
        this.passedCredits += credits;
    }

    public void addNum(int num) {
        this.passedCount += num;
    }

    public boolean isPassed() {
        return this.getRequiredCredits() <= this.getPassedCredits() + this.getConvertedCredits() && this.getRequiredCount() <= this.getPassedCount();
    }

    public float getCreditNeeded(boolean returnNegative) {
        float needToComplete = this.requiredCredits - this.convertedCredits - this.passedCredits;
        if (needToComplete < 0.0f) {
            if (returnNegative) {
                return needToComplete;
            }
            return 0.0f;
        }
        return needToComplete;
    }

    public int getRequiredCount() {
        return this.requiredCount;
    }

    public void setRequiredCount(int requiredCountRequired) {
        this.requiredCount = requiredCountRequired;
    }

    public float getPassedCredits() {
        return this.passedCredits;
    }

    public void setPassedCredits(float creditsCompleted) {
        this.passedCredits = creditsCompleted;
    }

    public float getRequiredCredits() {
        return this.requiredCredits;
    }

    public void setRequiredCredits(float creditsRequired) {
        this.requiredCredits = creditsRequired;
    }

    public Set<Course> getPassedCourses() {
        return this.passedCourses;
    }

    public void setPassedCourses(Set<Course> passCourses) {
        this.passedCourses = passCourses;
    }

    public int getPassedCount() {
        return this.passedCount;
    }

    public void setPassedCount(int totalRequiredCount) {
        this.passedCount = totalRequiredCount;
    }

    public float getConvertedCredits() {
        return this.convertedCredits;
    }

    public void setConvertedCredits(float creditsConverted) {
        this.convertedCredits = creditsConverted;
    }

    public void reduceRequired(float credits, int num) {
        this.requiredCredits -= credits;
        this.requiredCredits = this.requiredCredits < 0.0f ? 0.0f : this.requiredCredits;
        this.requiredCount -= num;
        this.requiredCount = this.requiredCount < 0 ? 0 : this.requiredCount;
    }
}

