/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.model;

import java.sql.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.NumberIdTimeObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.openurp.base.edu.code.CourseType;
import org.openurp.base.edu.code.StdType;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.Project;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.code.edu.model.Degree;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.edu.model.StudyType;
import org.openurp.edu.program.model.TermCampus;

@Cacheable
@Cache(region="edu.course", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Entity(name="org.openurp.edu.program.model.Program")
public class Program
extends NumberIdTimeObject<Long>
implements Cloneable {
    private static final long serialVersionUID = 4260627210556648248L;
    @NotNull
    @Size(max=200)
    private String name;
    @NotNull
    private String grade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;
    @ManyToOne(fetch=FetchType.LAZY)
    private Department department;
    @ManyToOne(fetch=FetchType.LAZY)
    private EducationLevel level;
    @ManyToOne(fetch=FetchType.LAZY)
    private StdType stdType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Major major;
    @ManyToOne(fetch=FetchType.LAZY)
    private Direction direction;
    @NotNull
    private Float duration;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private StudyType studyType;
    @ManyToOne(fetch=FetchType.LAZY)
    private Degree degree;
    @NotNull
    private Date beginOn;
    private Date endOn;
    @Size(max=800)
    private String remark;
    private Float degreeGpa;
    @NotNull
    @Type(type="org.beangle.orm.hibernate.udt.IDEnumType")
    private AuditStatus status = AuditStatus.UNSUBMITTED;
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseType offsetType;
    @OneToMany(targetEntity=TermCampus.class, cascade={CascadeType.ALL})
    @JoinColumn(name="program_id", nullable=true)
    private List<TermCampus> termCampuses = CollectUtils.newArrayList();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private Set<Course> degreeCourses = CollectUtils.newHashSet();

    public Program() {
    }

    public Program(Long id) {
        super((Number)id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public EducationLevel getLevel() {
        return this.level;
    }

    public void setLevel(EducationLevel level) {
        this.level = level;
    }

    public StdType getStdType() {
        return this.stdType;
    }

    public void setStdType(StdType stdType) {
        this.stdType = stdType;
    }

    public Major getMajor() {
        return this.major;
    }

    public void setMajor(Major major) {
        this.major = major;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public Float getDuration() {
        return this.duration;
    }

    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public StudyType getStudyType() {
        return this.studyType;
    }

    public void setStudyType(StudyType studyType) {
        this.studyType = studyType;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public AuditStatus getStatus() {
        return this.status;
    }

    public void setStatus(AuditStatus status) {
        this.status = status;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public Float getDegreeGpa() {
        return this.degreeGpa;
    }

    public void setDegreeGpa(Float degreeGpa) {
        this.degreeGpa = degreeGpa;
    }

    public CourseType getOffsetType() {
        return this.offsetType;
    }

    public void setOffsetType(CourseType offsetType) {
        this.offsetType = offsetType;
    }

    public List<TermCampus> getTermCampuses() {
        return this.termCampuses;
    }

    public void setTermCampuses(List<TermCampus> termCampuses) {
        this.termCampuses = termCampuses;
    }

    public Set<Course> getDegreeCourses() {
        return this.degreeCourses;
    }

    public void setDegreeCourses(Set<Course> degreeCourses) {
        this.degreeCourses = degreeCourses;
    }
}

