/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.textbook.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.openurp.base.edu.model.Textbook;
import org.openurp.edu.clazz.model.Clazz;

@Entity(name="org.openurp.edu.textbook.model.Material")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
public class Material
extends LongIdObject {
    private static final long serialVersionUID = 5112094284404799375L;
    @NaturalId
    @ManyToOne(fetch=FetchType.LAZY)
    private Clazz clazz;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="edu.course")
    private List<Textbook> books = CollectUtils.newArrayList();
    @Size(max=500)
    private String materials;
    private Boolean passed;
    private Date submitAt;
    @Size(max=200)
    private String remark;
    private boolean ordered;
    @NotNull
    @Enumerated
    private BookAdoption adoption = BookAdoption.None;

    public Clazz getClazz() {
        return this.clazz;
    }

    public void setClazz(Clazz clazz) {
        this.clazz = clazz;
    }

    public List<Textbook> getBooks() {
        return this.books;
    }

    public boolean addBook(Textbook book) {
        return this.books.add(book);
    }

    public boolean addBooks(Collection<Textbook> textbooks) {
        return this.books.addAll(textbooks);
    }

    public boolean removeBook(Textbook book) {
        return this.books.remove((Object)book);
    }

    public boolean removeBooks(Collection<Textbook> textbooks) {
        return this.books.removeAll(textbooks);
    }

    public void setBooks(List<Textbook> books) {
        this.books = books;
    }

    public Boolean getPassed() {
        return this.passed;
    }

    public void setPassed(Boolean passed) {
        this.passed = passed;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getMaterials() {
        return this.materials;
    }

    public void setMaterials(String materials) {
        this.materials = materials;
    }

    public Date getSubmitAt() {
        return this.submitAt;
    }

    public void setSubmitAt(Date submitAt) {
        this.submitAt = submitAt;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public BookAdoption getAdoption() {
        return this.adoption;
    }

    public void setAdoption(BookAdoption adoption) {
        this.adoption = adoption;
    }

    public static enum BookAdoption {
        None("\u63a8\u8350\u53c2\u8003\u4e66"),
        UseTextBook("\u4f7f\u7528\u6559\u6750"),
        UseLecture("\u4f7f\u7528\u6559\u4e49");

        private String fullName;

        private BookAdoption() {
        }

        private BookAdoption(String fullName) {
            this.fullName = fullName;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

