/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.beangle.commons.bean.comparators.PropertyComparator;
import org.beangle.commons.lang.Strings;
import org.openurp.code.edu.model.ExamStatus;
import org.openurp.code.edu.model.GradeType;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.model.ExamGrade;
import org.openurp.edu.grade.course.model.GaGrade;

public class GradeRemarkDigester {
    public String digest(List<CourseGrade> grades) {
        ArrayList<CourseGrade> newGrades = new ArrayList<CourseGrade>(grades);
        StringBuilder remarkSB = new StringBuilder();
        Collections.sort(newGrades, new PropertyComparator("semester"));
        String brString = "";
        for (CourseGrade grade : newGrades) {
            remarkSB.append(brString);
            remarkSB.append(grade.getSemester().getSchoolYear()).append(grade.getSemester().getName()).append(" ");
            GaGrade ga = grade.getGaGrade(new GradeType(GradeType.GA_ID));
            remarkSB.append("\u671f\u672b");
            if (null == ga || Strings.isBlank((CharSequence)ga.getScoreText())) {
                remarkSB.append(this.disgetExamGrade(grade.getExamGrade(new GradeType(GradeType.END_ID))));
            } else {
                remarkSB.append(ga.getScoreText());
            }
            GaGrade delay = grade.getGaGrade(new GradeType(GradeType.DELAY_GA_ID));
            if (null == delay) {
                remarkSB.append("  \u8865\u8003");
                GaGrade makeup = grade.getGaGrade(new GradeType(GradeType.MAKEUP_GA_ID));
                if (null == makeup || Strings.isBlank((CharSequence)makeup.getScoreText())) {
                    remarkSB.append(this.disgetExamGrade(grade.getExamGrade(new GradeType(GradeType.MAKEUP_ID))));
                } else {
                    remarkSB.append(makeup.getScoreText());
                }
            } else {
                remarkSB.append("  \u7f13\u8003");
                if (Strings.isBlank((CharSequence)delay.getScoreText())) {
                    remarkSB.append(this.disgetExamGrade(grade.getExamGrade(new GradeType(GradeType.DELAY_ID))));
                } else {
                    remarkSB.append(delay.getScoreText());
                }
            }
            brString = "\n";
        }
        return remarkSB.toString();
    }

    public String disgetExamGrade(ExamGrade eg) {
        if (null == eg) {
            return "--";
        }
        if (Strings.isNotBlank((CharSequence)eg.getScoreText()) && ((Integer)eg.getExamStatus().getId()).equals(ExamStatus.NORMAL)) {
            return eg.getScoreText();
        }
        return eg.getExamStatus().getName();
    }
}

