/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.openurp.base.edu.model.Project;
import org.openurp.base.std.model.Grade;
import org.openurp.code.edu.model.AcademicLevel;
import org.openurp.edu.program.model.ShareCourseGroup;

@Entity(name="org.openurp.edu.program.model.SharePlan")
public class SharePlan
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -9012605313915822262L;
    @NotNull
    @Size(max=255)
    private String name;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Grade fromGrade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Grade toGrade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @ManyToOne(fetch=FetchType.LAZY)
    private AcademicLevel level;
    @OneToMany(mappedBy="plan", targetEntity=ShareCourseGroup.class)
    @OrderBy(value="indexno")
    @Cascade(value={CascadeType.ALL})
    protected List<ShareCourseGroup> groups = CollectUtils.newArrayList();
    @NotNull
    private java.sql.Date beginOn;
    private java.sql.Date endOn;
    protected Date createdAt;
    protected Date updatedAt;
    @Size(max=100)
    private String remark;

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public List<ShareCourseGroup> getTopCourseGroups() {
        if (this.getGroups() == null) {
            return new ArrayList<ShareCourseGroup>();
        }
        ArrayList<ShareCourseGroup> res = new ArrayList<ShareCourseGroup>();
        for (ShareCourseGroup group : this.getGroups()) {
            if (group == null || group.getParent() != null) continue;
            res.add(group);
        }
        return res;
    }

    public Object clone() throws CloneNotSupportedException {
        SharePlan shareCoursePlan = (SharePlan)super.clone();
        shareCoursePlan.setGroups(new ArrayList<ShareCourseGroup>());
        shareCoursePlan.setId(null);
        for (ShareCourseGroup cg : this.getGroups()) {
            if (null != cg.getParent()) continue;
            ShareCourseGroup cgClone = (ShareCourseGroup)cg.clone();
            cgClone.setPlan(shareCoursePlan);
            shareCoursePlan.addGroup(cgClone);
        }
        return shareCoursePlan;
    }

    public void addGroup(ShareCourseGroup group) {
        if (null == this.getGroups()) {
            this.setGroups(new ArrayList<ShareCourseGroup>());
        }
        this.getGroups().add(group);
        group.updateCoursePlan(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AcademicLevel getLevel() {
        return this.level;
    }

    public void setLevel(AcademicLevel level) {
        this.level = level;
    }

    public List<ShareCourseGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<ShareCourseGroup> groups) {
        this.groups = groups;
    }

    public java.sql.Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(java.sql.Date beginOn) {
        this.beginOn = beginOn;
    }

    public java.sql.Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(java.sql.Date endOn) {
        this.endOn = endOn;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Grade getFromGrade() {
        return this.fromGrade;
    }

    public void setFromGrade(Grade fromGrade) {
        this.fromGrade = fromGrade;
    }

    public Grade getToGrade() {
        return this.toGrade;
    }

    public void setToGrade(Grade toGrade) {
        this.toGrade = toGrade;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

