/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.dao.query.builder.SqlQuery;
import org.openurp.base.edu.model.CourseUnit;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.service.OccupyProcessor;
import org.openurp.base.service.SqlDao;
import org.openurp.base.service.StudentSource;
import org.openurp.base.service.impl.AbstractStdOccupyProvider;
import org.openurp.base.service.wrapper.StdOccupy;
import org.openurp.base.service.wrapper.TimeZone;
import org.openurp.base.std.model.Student;
import org.openurp.edu.clazz.model.CourseTaker;

public class CourseTakerOccupyProvider
extends AbstractStdOccupyProvider {
    private SqlDao sqlDao;

    public CourseTakerOccupyProvider() {
    }

    public CourseTakerOccupyProvider(Semester semester, EntityDao entityDao) {
        this.semester = semester;
        this.entityDao = entityDao;
    }

    @Override
    public Map getOccupyCount(StudentSource source, TimeZone zone) {
        ArrayList<String> sqls = new ArrayList<String>();
        String tmpTable = "tmp_" + System.currentTimeMillis();
        String createTableSql = "create  table " + tmpTable + "(stdId number(19) primary key)";
        sqls.add(createTableSql);
        for (Student std : source.getStudents()) {
            StringBuilder sb = new StringBuilder(80);
            sb.append("insert into ").append(tmpTable);
            sb.append(" values(").append(std.getId()).append(")");
            sqls.add(sb.toString());
        }
        this.sqlDao.batchUpdate(sqls);
        String occupyQuery = "select count(*) as c from jxbxs_t jxb, jxrw_t rw where jxb.jxrwid=rw.id  and exists(select * from " + tmpTable + " tmpstd where tmpstd.stdId=jxb.xsid) and rw.xnxqid=:semesterId and rw.kclbid not in(93,43) and (exists (select hd.id from pk_kchd_t hd, jszy_t zy where rw.id=hd.jxrwid and hd.jszyid=zy.id and zy.zj=:weekId and zy.qssj<:endTime and zy.jssj>:startTime and bitand(zy.yxzsz, :weekState)>0))";
        SqlQuery query = new SqlQuery(occupyQuery);
        HashMap<String, Number> params = new HashMap<String, Number>();
        query.setParams(params);
        params.put("semesterId", this.semester.getId());
        Map occupis = this.executeOccupyQuery((QueryBuilder)query, zone, new OccupyProcessor(){

            @Override
            public void process(Map weekOccupy, CourseUnit unit, List datas) {
                Number count = (Number)weekOccupy.get(unit);
                if (null == count) {
                    count = new Integer(0);
                }
                count = new Integer(count.intValue() + ((Number)datas.get(0)).intValue());
                weekOccupy.put(unit, count);
            }
        });
        sqls.clear();
        sqls.add("drop table " + tmpTable);
        this.sqlDao.batchUpdate(sqls);
        return occupis;
    }

    @Override
    public Map getOccupyInfo(StudentSource source, TimeZone zone) {
        OqlBuilder query = OqlBuilder.from(CourseTaker.class, (String)"taker");
        query.where("taker.std in (:stds)");
        query.where("taker.clazz.semester=:semester");
        query.where("exists( from taker.clazz.schedule.activities activity where activity.time.weekday=:weekId and activity.time.startOn < :startOn and activity.time.beginAt < :endTime and activity.time.endAt >:startTime and bitand(activity.time.weekstate,:weekState)>0 )");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("stds", source.getStudents());
        params.put("semester", this.semester);
        query.params(params);
        Map occupis = this.executeOccupyQuery((QueryBuilder)query, zone, new OccupyProcessor(){

            @Override
            public void process(Map weekOccupy, CourseUnit unit, List datas) {
                ArrayList<StdOccupy> list = (ArrayList<StdOccupy>)weekOccupy.get(unit);
                if (null == list) {
                    list = new ArrayList<StdOccupy>();
                }
                list.addAll(this.courseTakerToOccupy(datas));
                weekOccupy.put(unit, list);
            }

            private List<StdOccupy> courseTakerToOccupy(List<CourseTaker> takers) {
                ArrayList<StdOccupy> o = new ArrayList<StdOccupy>();
                for (CourseTaker taker : takers) {
                    StdOccupy occupy = new StdOccupy();
                    occupy.setStd(taker.getStd());
                    occupy.setCourse(taker.getClazz().getCourse());
                    occupy.setRemark("\u4e0a\u8bfe");
                    o.add(occupy);
                }
                return o;
            }
        });
        return occupis;
    }

    public void setSqlDao(SqlDao sqlDao) {
        this.sqlDao = sqlDao;
    }
}

