/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.std.service;

import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Squad;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.model.Program;

public class SquadQueryBuilder {
    private SquadQueryBuilder() {
    }

    public static OqlBuilder<Squad> build(ExecutionPlan plan) {
        Program program = plan.getProgram();
        OqlBuilder query = OqlBuilder.from(Squad.class, (String)"squad");
        query.where("squad.grade=:grade", (Object)program.getGrade());
        query.where("squad.major=:major", (Object)program.getMajor());
        query.where("squad.level=:level", (Object)program.getLevel());
        Set departs = CollectUtils.newHashSet((Object[])new Department[]{plan.getDepartment()});
        departs.addAll(plan.getDepartment().getChildren());
        query.where("squad.department in(:departments)", (Object)departs);
        if (null == program.getDirection()) {
            query.where("squad.direction is null");
        } else {
            query.where("squad.direction = :direction", (Object)program.getDirection());
        }
        return query;
    }
}

