/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Teacher;
import org.openurp.edu.clazz.model.Clazz;

public class ClazzLogBuilder {
    public static final String TYPE = "TYPE";
    public static final String LESSON_ID = "LESSON.ID";
    public static final String LESSON_PROJECT = "LESSON.PROJECT";
    public static final String LESSON_SEMESTER = "LESSON.SEMESTER";
    public static final String LESSON_NO = "LESSON.NO";
    public static final String COURSE_CODE = "LESSON.COURSE.CODE";
    public static final String COURSE_NAME = "LESSON.COURSE.NAME";
    public static final String REASON = "REASON";
    public static final String DETAIL = "DETAIL";
    public static final String[] LOG_FIELDS = new String[]{"LESSON.ID", "TYPE", "LESSON.PROJECT", "LESSON.SEMESTER", "LESSON.NO", "LESSON.COURSE.CODE", "LESSON.COURSE.NAME", "REASON", "DETAIL"};

    private static Map<String, String> makeInformations(Clazz clazz) {
        HashMap<String, String> empty = new HashMap<String, String>();
        for (int i = 0; i < LOG_FIELDS.length; ++i) {
            empty.put(LOG_FIELDS[i], "");
        }
        empty.put(LESSON_ID, String.valueOf(clazz.getId()));
        empty.put(LESSON_PROJECT, String.valueOf(clazz.getProject().getName()));
        empty.put(LESSON_SEMESTER, clazz.getSemester().getSchoolYear() + "-" + clazz.getSemester().getName());
        empty.put(LESSON_NO, clazz.getCrn());
        empty.put(COURSE_CODE, clazz.getCourse().getCode());
        empty.put(COURSE_NAME, clazz.getCourse().getName());
        return empty;
    }

    private static String toString(Map<String, String> informations) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < LOG_FIELDS.length; ++i) {
            sb.append(LOG_FIELDS[i]).append("=").append(informations.get(LOG_FIELDS[i]));
            if (i == LOG_FIELDS.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String create(Clazz clazz, String reason) {
        Map<String, String> map = ClazzLogBuilder.makeInformations(clazz);
        map.put(TYPE, Operation.CREATE.name());
        map.put(DETAIL, ClazzLogBuilder.stringify(clazz));
        if (Strings.isNotEmpty((CharSequence)reason)) {
            map.put(REASON, reason);
        }
        return ClazzLogBuilder.toString(map);
    }

    public static String delete(Clazz clazz, String reason) {
        Map<String, String> map = ClazzLogBuilder.makeInformations(clazz);
        map.put(TYPE, Operation.DELETE.name());
        if (Strings.isNotEmpty((CharSequence)reason)) {
            map.put(REASON, reason);
        }
        return ClazzLogBuilder.toString(map);
    }

    public static String update(Clazz clazz, String reason) {
        Map<String, String> map = ClazzLogBuilder.makeInformations(clazz);
        map.put(TYPE, Operation.UPDATE.name());
        map.put(DETAIL, ClazzLogBuilder.stringify(clazz));
        if (Strings.isNotEmpty((CharSequence)reason)) {
            map.put(REASON, reason);
        }
        return ClazzLogBuilder.toString(map);
    }

    private static String stringify(Clazz clazz) {
        StringBuilder sb = new StringBuilder();
        ClazzLogBuilder.append(sb, "\u8bfe\u7a0b\u5e8f\u53f7", clazz.getCrn());
        ClazzLogBuilder.append(sb, "\u5b66\u671f", clazz.getSemester().getSchoolYear() + "-" + clazz.getSemester().getName());
        ClazzLogBuilder.append(sb, "\u8bfe\u7a0b", clazz.getCourse().getName() + "[" + clazz.getCourse().getCode() + "]");
        ClazzLogBuilder.append(sb, "\u6559\u5b66\u9879\u76ee", clazz.getProject().getName());
        ClazzLogBuilder.append(sb, "\u8bfe\u7a0b\u7c7b\u522b", clazz.getCourseType().getName());
        ClazzLogBuilder.append(sb, "\u5f00\u8bfe\u9662\u7cfb", clazz.getTeachDepart().getName());
        StringBuilder tsb = new StringBuilder();
        Iterator<Teacher> iter = clazz.getTeachers().iterator();
        while (iter.hasNext()) {
            Teacher teacher = iter.next();
            tsb.append(teacher.getName() + "[" + teacher.getCode() + "]");
            if (!iter.hasNext()) continue;
            tsb.append(',');
        }
        ClazzLogBuilder.append(sb, "\u6388\u8bfe\u6559\u5e08", tsb.toString());
        if (clazz.getLangType() != null) {
            ClazzLogBuilder.append(sb, "\u6388\u8bfe\u8bed\u8a00", clazz.getLangType().getName());
        } else {
            ClazzLogBuilder.append(sb, "\u6388\u8bfe\u8bed\u8a00", null);
        }
        ClazzLogBuilder.append(sb, "\u6302\u724c", 1);
        if (clazz.getCampus() != null) {
            ClazzLogBuilder.append(sb, "\u6821\u533a", clazz.getCampus().getName());
        } else {
            ClazzLogBuilder.append(sb, "\u6821\u533a", null);
        }
        ClazzLogBuilder.append(sb, "\u6559\u5b66\u73ed", clazz.getClazzName());
        ClazzLogBuilder.append(sb, "\u5e74\u7ea7", clazz.getEnrollment().getGrades());
        if (clazz.getEnrollment().getDepart() != null) {
            ClazzLogBuilder.append(sb, "\u4e0a\u8bfe\u9662\u7cfb", clazz.getEnrollment().getDepart().getName());
        } else {
            ClazzLogBuilder.append(sb, "\u4e0a\u8bfe\u9662\u7cfb", null);
        }
        ClazzLogBuilder.append(sb, "\u5b9e\u9645\u4eba\u6570", clazz.getEnrollment().getStdCount());
        ClazzLogBuilder.append(sb, "\u4eba\u6570\u4e0a\u9650", clazz.getEnrollment().getCapacity());
        ClazzLogBuilder.append(sb, "\u8d77\u59cb\u5468", clazz.getSchedule().getFirstWeek());
        ClazzLogBuilder.append(sb, "\u7ed3\u675f\u5468", clazz.getSchedule().getLastWeek());
        ClazzLogBuilder.append(sb, "\u8bfe\u65f6", clazz.getSchedule().getCreditHours());
        ClazzLogBuilder.append(sb, "\u5907\u6ce8", clazz.getRemark());
        sb.replace(sb.length() - 1, sb.length(), "");
        return sb.toString();
    }

    private static void append(StringBuilder sb, String fieldName, Object value) {
        if (value == null) {
            sb.append(fieldName).append("=\u7a7a\n");
        } else {
            sb.append(fieldName).append('=').append(value.toString()).append('\n');
        }
    }

    public static enum Operation {
        CREATE,
        DELETE,
        UPDATE;

    }
}

