/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.service.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.openurp.base.edu.model.Direction;
import org.openurp.base.edu.model.Major;
import org.openurp.base.model.Department;
import org.openurp.base.std.code.StdType;
import org.openurp.base.std.model.Squad;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.person.model.Gender;
import org.openurp.edu.clazz.model.Restriction;
import org.openurp.edu.clazz.model.RestrictionItem;
import org.openurp.edu.clazz.model.RestrictionMeta;
import org.openurp.edu.clazz.service.CourseLimitExtractorService;

public class CourseLimitExtractorServiceImpl
extends BaseServiceImpl
implements CourseLimitExtractorService {
    @Override
    public List<EducationLevel> extractEducations(Restriction restriction) {
        Pair<Boolean, List<EducationLevel>> res = this.xtractEducationLimit(restriction);
        if (((Boolean)res.getLeft()).booleanValue()) {
            return (List)res.getRight();
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Squad> extractSquades(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Squad.equals((Object)item.getMeta()) || !item.isIncluded()) continue;
            return this.entityDao.get(Squad.class, (Serializable[])Strings.splitToLong((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public String extractGrade(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Grade.equals((Object)item.getMeta()) || !item.isIncluded()) continue;
            return item.getContents();
        }
        return null;
    }

    @Override
    public List<StdType> extractStdTypes(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.StdType.equals((Object)item.getMeta()) || !item.isIncluded()) continue;
            return this.entityDao.get(StdType.class, (Serializable[])Strings.splitToInt((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Major> extractMajors(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Major.equals(item.getMeta().getId()) || !item.isIncluded()) continue;
            return this.entityDao.get(Major.class, (Serializable[])Strings.splitToLong((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Direction> extractDirections(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Direction.equals(item.getMeta().getId()) || !item.isIncluded()) continue;
            return this.entityDao.get(Direction.class, (Serializable[])Strings.splitToLong((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public List<Department> extractAttendDeparts(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Department.equals(item.getMeta().getId()) || !item.isIncluded()) continue;
            return this.entityDao.get(Department.class, (Serializable[])Strings.splitToInt((String)item.getContents()));
        }
        return CollectUtils.newArrayList();
    }

    @Override
    public Gender extractGender(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Gender.equals(item.getMeta().getId()) || !item.isIncluded()) continue;
            return (Gender)((Object)this.entityDao.get(Gender.class, (Serializable[])Strings.splitToInt((String)item.getContents())).get(0));
        }
        return null;
    }

    @Override
    public Pair<Boolean, List<EducationLevel>> xtractEducationLimit(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Level.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(EducationLevel.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<Squad>> xtractSquadLimit(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Squad.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Squad.class, (Serializable[])Strings.splitToLong((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<Department>> xtractAttendDepartLimit(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Department.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Department.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<Direction>> xtractDirectionLimit(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Direction.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Direction.class, (Serializable[])Strings.splitToLong((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<String>> xtractGradeLimit(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Gender.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)CollectUtils.newArrayList((Object[])new String[]{item.getContents()}));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<Major>> xtractMajorLimit(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.Major.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(Major.class, (Serializable[])Strings.splitToLong((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }

    @Override
    public Pair<Boolean, List<StdType>> xtractStdTypeLimit(Restriction restriction) {
        for (RestrictionItem item : restriction.getItems()) {
            if (!RestrictionMeta.StdType.equals(item.getMeta().getId())) continue;
            return new Pair((Object)item.isIncluded(), (Object)this.entityDao.get(StdType.class, (Serializable[])Strings.splitToInt((String)item.getContents())));
        }
        return new Pair((Object)Boolean.TRUE, new ArrayList());
    }
}

