/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.util;

import java.text.MessageFormat;
import java.util.List;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.model.Project;
import org.openurp.base.model.Department;
import org.openurp.base.std.code.StdType;
import org.openurp.code.edu.model.EducationLevel;

public class ClazzDataRealmBuilder {
    private EntityDao entityDao;
    private OqlBuilder query;
    private String clazzAlias;
    private static final String IN_PROJECTS = "{0}.project in (:projects_{1})";
    private static final String IN_TEACT_DEPARTS = "{0}.teachDepart in (:departs_{1})";
    private static final String IN_STDTYPES = "{0} in (:stdTypes_{1})";
    private static final String IN_EDUCATIONS = "{0} in (:levels_{1})";
    private static final String IN_PROJECT_IDS = "{0}.project.id in (:projectIds_{1})";
    private static final String IN_TEACH_DEPART_IDS = "{0}.teachDepart.id in (:departIds_{1})";
    private static final String IN_STDTYPE_IDS = "{0}.id in (:stdTypeIds_{1})";
    private static final String IN_EDUCATION_IDS = "{0}.id in (:levelIds_{1})";

    private ClazzDataRealmBuilder() {
    }

    private ClazzDataRealmBuilder(EntityDao entityDao, OqlBuilder query, String clazzAlias) {
        this.entityDao = entityDao;
        this.query = query;
        this.clazzAlias = clazzAlias;
    }

    public static ClazzDataRealmBuilder start(EntityDao entityDao, OqlBuilder query, String clazzAlias) {
        return new ClazzDataRealmBuilder(entityDao, query, clazzAlias);
    }

    public ClazzDataRealmBuilder restrictProjects(List<Project> projects) {
        this.query.where(MessageFormat.format(IN_PROJECTS, this.clazzAlias, System.currentTimeMillis()), projects);
        return this;
    }

    public ClazzDataRealmBuilder restrictTeachDeparts(List<Department> departs) {
        this.query.where(MessageFormat.format(IN_TEACT_DEPARTS, this.clazzAlias, System.currentTimeMillis()), departs);
        return this;
    }

    public ClazzDataRealmBuilder restrictStdTypes(List<StdType> stdTypes) {
        return this;
    }

    public ClazzDataRealmBuilder restrictEducations(List<EducationLevel> levels) {
        return this;
    }

    public ClazzDataRealmBuilder restrictProjects(Integer[] projectIds) {
        this.query.where(MessageFormat.format(IN_PROJECT_IDS, this.clazzAlias, System.currentTimeMillis()), (Object)projectIds);
        return this;
    }

    public ClazzDataRealmBuilder restrictTeachDeparts(Long[] departIds) {
        this.query.where(MessageFormat.format(IN_TEACH_DEPART_IDS, this.clazzAlias, System.currentTimeMillis()), (Object)departIds);
        return this;
    }

    public ClazzDataRealmBuilder restrictStdTypes(Integer[] stdTypeIds) {
        return this;
    }

    public ClazzDataRealmBuilder restrictEducations(Integer[] levelIds) {
        return this;
    }

    public OqlBuilder finish() {
        return this.query;
    }
}

