/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.beangle.commons.text.i18n.TextResource;
import org.beangle.commons.transfer.exporter.DefaultPropertyExtractor;
import org.openurp.base.edu.model.Classroom;
import org.openurp.base.edu.model.Teacher;
import org.openurp.base.edu.model.Textbook;
import org.openurp.base.edu.model.TimeSetting;
import org.openurp.base.service.SemesterService;
import org.openurp.base.service.TimeSettingService;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.edu.model.ExamType;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzActivity;
import org.openurp.edu.clazz.model.Restriction;
import org.openurp.edu.clazz.service.CourseLimitService;
import org.openurp.edu.clazz.util.ScheduleDigestor;
import org.openurp.edu.exam.util.ExamActivityDigestor;
import org.openurp.edu.textbook.model.Material;

public class TeachTaskPropertyExtractor
extends DefaultPropertyExtractor {
    protected String courseActivityFormat;
    protected String examActivityFormat;
    protected ExamType examType;
    protected SemesterService semesterService;
    protected TimeSettingService timeSettingService;
    protected CourseLimitService courseLimitService;
    protected EntityDao entityDao;
    protected List<TeachingNature> teachingNatures = new ArrayList<TeachingNature>();

    public TeachTaskPropertyExtractor(TextResource resource) {
        super(resource);
    }

    public Object getPropertyValue(Object target, String property) throws Exception {
        Clazz clazz = (Clazz)target;
        TimeSetting timeSetting = this.timeSettingService.getClosestTimeSetting(clazz.getProject(), clazz.getSemester(), null);
        ScheduleDigestor digestor = ScheduleDigestor.getInstance();
        ExamActivityDigestor examDigestor = ExamActivityDigestor.getInstance();
        if ("fake.teachers".equals(property)) {
            StringBuilder sb = new StringBuilder();
            Iterator<Teacher> iter = clazz.getTeachers().iterator();
            while (iter.hasNext()) {
                Teacher teacher = iter.next();
                sb.append(teacher.getName()).append('[').append(teacher.getCode()).append(']');
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            return sb.toString();
        }
        if ("teachers.eduDegreeInside".equals(property)) {
            Object eduDegreeNames = "";
            if (clazz.getTeachers() != null) {
                boolean singleTeacher = clazz.getTeachers().size() == 1;
                for (Teacher teacher : clazz.getTeachers()) {
                    if (singleTeacher) {
                        return super.getPropertyValue((Object)teacher, "degreeInfo.eduDegreeInside.name");
                    }
                    if (eduDegreeNames != "") {
                        eduDegreeNames = (String)eduDegreeNames + " ";
                    }
                    eduDegreeNames = (String)eduDegreeNames + super.getPropertyValue((Object)teacher, "degreeInfo.eduDegreeInside.name") + " ";
                }
            }
            return eduDegreeNames;
        }
        if ("teachers.degree".equals(property)) {
            Object degreeNames = "";
            if (clazz.getTeachers() != null) {
                boolean singleTeacher = clazz.getTeachers().size() == 1;
                for (Teacher teacher : clazz.getTeachers()) {
                    if (singleTeacher) {
                        return super.getPropertyValue((Object)teacher, "degreeInfo.degree.name");
                    }
                    if (degreeNames != "") {
                        degreeNames = (String)degreeNames + " ";
                    }
                    degreeNames = (String)degreeNames + super.getPropertyValue((Object)teacher, "degreeInfo.degree.name") + " ";
                }
            }
            return degreeNames;
        }
        if ("teachers.teacherType".equals(property)) {
            return this.getPropertyIn(clazz.getTeachers(), "teacherType.name");
        }
        if ("teachers.department.name".equals(property)) {
            return this.getPropertyIn(clazz.getTeachers(), "department.name");
        }
        if ("fake.semester".equals(property)) {
            return clazz.getSemester().getSchoolYear() + "-" + clazz.getSemester().getName();
        }
        if ("fake.state".equals(property)) {
            return clazz.getStatus().getFullName();
        }
        if ("semester".equals(property)) {
            return clazz.getSemester().getSchoolYear() + " " + clazz.getSemester().getName();
        }
        if ("courseSchedule.activities.weeks".equals(property)) {
            return digestor.digest(this.textResource, timeSetting, clazz, ":weeks");
        }
        if ("fake.weeks".equals(property)) {
            return clazz.getSchedule().getWeeks();
        }
        if ("fake.arrange".equals(property)) {
            return digestor.digest(this.textResource, timeSetting, clazz, ":day :units :weeks :room");
        }
        if ("roomType.name".equals(property)) {
            if (clazz.getSchedule().getRoomType() != null) {
                return clazz.getSchedule().getRoomType().getName();
            }
            return "";
        }
        if ("fake.schedule.practiceHour".equals(property)) {
            TeachingNature type = null;
            for (TeachingNature hourType : this.teachingNatures) {
                if (hourType.getName().indexOf("\u5b9e\u8df5") == -1) continue;
                type = hourType;
            }
            if (type != null) {
                return clazz.getCourse().getHour(type);
            }
            return null;
        }
        if ("fake.schedule.theoryHour".equals(property)) {
            TeachingNature type = null;
            for (TeachingNature nature : this.teachingNatures) {
                if (nature.getName().indexOf("\u7406\u8bba") == -1) continue;
                type = nature;
            }
            if (type != null) {
                return clazz.getCourse().getHour(type);
            }
            return null;
        }
        if ("fake.schedule.operateHour".equals(property)) {
            TeachingNature type = null;
            for (TeachingNature nature : this.teachingNatures) {
                if (nature.getName().indexOf("\u4e0a\u673a") == -1 && nature.getName().indexOf("\u64cd\u4f5c") == -1) continue;
                type = nature;
            }
            if (type != null) {
                return clazz.getCourse().getHour(type);
            }
            return null;
        }
        if ("fake.materials".equals(property)) {
            StringBuilder sb = new StringBuilder();
            OqlBuilder query = OqlBuilder.from(Material.class, (String)"book");
            query.where("book.clazz = :clazz", (Object)clazz);
            Material material = (Material)((Object)this.entityDao.uniqueResult((QueryBuilder)query));
            if (material != null) {
                Iterator<Textbook> iter = material.getBooks().iterator();
                while (iter.hasNext()) {
                    Textbook book = iter.next();
                    sb.append(MessageFormat.format("\u540d\u79f0:{0},\u4f5c\u8005:{1},ISBN:{2},\u51fa\u7248\u793e:{3}", book.getName(), book.getAuthor() == null ? "" : book.getAuthor(), book.getIsbn() == null ? "" : book.getIsbn(), book.getPress() == null ? "" : book.getPress().getName()));
                    if (!iter.hasNext()) continue;
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        if ("courseSchedule.activities.room.capacityOfCourse".equals(property)) {
            HashSet<Classroom> rooms = new HashSet<Classroom>();
            for (ClazzActivity activity : clazz.getSchedule().getActivities()) {
                rooms.addAll(activity.getRooms());
            }
            Object[] seats = new Integer[rooms.size()];
            int i = 0;
            for (Classroom room : rooms) {
                seats[i++] = room.getCourseCapacity();
            }
            return Strings.join((Object[])seats, (char)',');
        }
        if ("courseSchedule.activities.time".equals(property)) {
            return digestor.digest(this.textResource, timeSetting, clazz, ":day :units");
        }
        if ("courseSchedule.activities.room".equals(property)) {
            HashSet<Classroom> rooms = new HashSet<Classroom>();
            for (ClazzActivity activity : clazz.getSchedule().getActivities()) {
                rooms.addAll(activity.getRooms());
            }
            String[] names = new String[rooms.size()];
            int i = 0;
            for (Classroom room : rooms) {
                names[i++] = room.getName();
            }
            return Strings.join((String[])names, (String)",");
        }
        if ("clazz.schedule".equals(property)) {
            Object arrangeInfo = "";
            int weeks = clazz.getSchedule().getWeeks();
            float weekUnits = clazz.getSchedule().getWeekHours();
            if (0 != weeks && 0.0f != weekUnits) {
                arrangeInfo = weeks + "*" + weekUnits;
            }
            return arrangeInfo;
        }
        if ("eduLevel.name".equals(property)) {
            Map<Restriction, Pair<Boolean, List<EducationLevel>>> tmpRes = this.courseLimitService.xtractEducationLimit(clazz.getEnrollment());
            Object eduLevelStr = "";
            for (Pair<Boolean, List<EducationLevel>> pair : tmpRes.values()) {
                if (!((Boolean)pair._1).booleanValue()) {
                    for (EducationLevel level : (List)pair._2) {
                        if (Strings.contains((CharSequence)eduLevelStr, (CharSequence)(level.getName() + "(\u4e0d\u5305\u62ec)"))) continue;
                        if (Strings.isNotBlank((CharSequence)eduLevelStr)) {
                            eduLevelStr = (String)eduLevelStr + ",";
                        }
                        eduLevelStr = (String)eduLevelStr + level.getName() + "(\u4e0d\u5305\u62ec)";
                    }
                }
                if (!((Boolean)pair._1).booleanValue()) continue;
                for (EducationLevel level : (List)pair._2) {
                    if (Strings.contains((CharSequence)eduLevelStr, (CharSequence)(level.getName() + "(\u5305\u62ec)"))) continue;
                    if (Strings.isNotBlank((CharSequence)eduLevelStr)) {
                        eduLevelStr = (String)eduLevelStr + ",";
                    }
                    eduLevelStr = (String)eduLevelStr + level.getName() + "(\u5305\u62ec)";
                }
            }
            return eduLevelStr;
        }
        if ("teachLang.name".equals(property)) {
            if (clazz.getLangType() != null) {
                return clazz.getLangType().getName();
            }
            return "";
        }
        try {
            return super.getPropertyValue(target, property);
        }
        catch (Exception e) {
            System.out.println("Cannot find " + property + " in clazz");
            return "";
        }
    }

    public void setSemesterService(SemesterService semesterService) {
        this.semesterService = semesterService;
    }

    public void setCourseLimitService(CourseLimitService courseLimitService) {
        this.courseLimitService = courseLimitService;
    }

    public void setSessionFormat(String courseActivityFormat) {
        this.courseActivityFormat = courseActivityFormat;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
        this.teachingNatures = entityDao.getAll(TeachingNature.class);
    }

    public void setTimeSettingService(TimeSettingService timeSettingService) {
        this.timeSettingService = timeSettingService;
    }
}

