/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.app.model;

import java.sql.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.base.edu.code.CourseType;
import org.openurp.base.std.model.StudentScope;

@Entity(name="org.openurp.edu.grade.app.model.AuditSetting")
public class AuditSetting
extends LongIdObject {
    private static final long serialVersionUID = 6149971489639130484L;
    @ManyToMany
    private Set<CourseType> excludes = new HashSet<CourseType>();
    @ManyToMany
    @JoinTable(name="", joinColumns={@JoinColumn(name="audit_setting_id")}, inverseJoinColumns={@JoinColumn(name="")})
    private Set<CourseType> convertables = new HashSet<CourseType>();
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseType convertTarget;
    @Size(max=500)
    @NotNull
    private String name;
    @Embedded
    @AssociationOverrides(value={@AssociationOverride(name="levels", joinTable=@JoinTable(name="audit_settings_levels", joinColumns={@JoinColumn(name="audit_setting_id", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="level_id", referencedColumnName="ID")})), @AssociationOverride(name="stdTypes", joinTable=@JoinTable(name="audit_settings_std_types", joinColumns={@JoinColumn(name="audit_setting_id", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="STD_TYPE_ID", referencedColumnName="ID")})), @AssociationOverride(name="departments", joinTable=@JoinTable(name="audit_settings_departments", joinColumns={@JoinColumn(name="audit_setting_id", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="DEPARTMENT_ID", referencedColumnName="ID")})), @AssociationOverride(name="majors", joinTable=@JoinTable(name="audit_settings_majors", joinColumns={@JoinColumn(name="audit_setting_id", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="MAJOR_ID", referencedColumnName="ID")})), @AssociationOverride(name="directions", joinTable=@JoinTable(name="audit_settings_directions", joinColumns={@JoinColumn(name="audit_setting_id", referencedColumnName="ID")}, inverseJoinColumns={@JoinColumn(name="DIRECTION_ID", referencedColumnName="ID")}))})
    private StudentScope studentScope = new StudentScope();
    @NotNull
    private Date beginOn;
    private Date endOn;

    public AuditSetting() {
    }

    public AuditSetting(Long id) {
        super(id);
    }

    public static AuditSetting empty(CourseType ctype) {
        CourseType electiveType = ctype;
        if (null == electiveType) {
            electiveType = new CourseType(-1);
            electiveType.setName("\u8ba1\u5212\u5916");
        }
        return new AuditSetting(CollectUtils.newHashSet(), CollectUtils.newHashSet(), electiveType);
    }

    public AuditSetting(Set<CourseType> disauditCourseTypes, Set<CourseType> convertableCourseTypes, CourseType convertTargetCourseType) {
        this.excludes = disauditCourseTypes;
        this.convertables = convertableCourseTypes;
        if (null == convertTargetCourseType) {
            CourseType electiveType = new CourseType(-1);
            electiveType.setName("\u8ba1\u5212\u5916");
            this.convertTarget = electiveType;
        } else {
            this.convertTarget = convertTargetCourseType;
        }
    }

    public boolean isConvertable(CourseType courseType) {
        return this.convertables.contains((Object)courseType);
    }

    public boolean isDisaudit(CourseType courseType) {
        if (CollectUtils.isNotEmpty(this.excludes)) {
            return this.excludes.contains((Object)courseType);
        }
        return false;
    }

    public boolean isConvertableCourseType(CourseType courseType) {
        if (CollectUtils.isNotEmpty(this.convertables)) {
            return this.convertables.contains((Object)courseType);
        }
        return false;
    }

    public Set<CourseType> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Set<CourseType> excludes) {
        this.excludes = excludes;
    }

    public Set<CourseType> getConvertables() {
        return this.convertables;
    }

    public void setConvertables(Set<CourseType> convertables) {
        this.convertables = convertables;
    }

    public CourseType getConvertTarget() {
        return this.convertTarget;
    }

    public void setConvertTarget(CourseType convertTarget) {
        this.convertTarget = convertTarget;
    }

    public AuditSetting toSetting() {
        return new AuditSetting(this.excludes, this.convertables, this.convertTarget);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StudentScope getStudentScope() {
        return this.studentScope;
    }

    public void setStudentScope(StudentScope studentScope) {
        this.studentScope = studentScope;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }
}

