/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.course.service.impl.GradeComparator;
import org.openurp.edu.grade.course.service.impl.GradeFilter;
import org.openurp.edu.program.model.AlternativeCourse;
import org.openurp.edu.program.plan.service.AlternativeCourseService;

public class BestOriginGradeFilter
implements GradeFilter {
    private AlternativeCourseService alternativeCourseService;

    private Map<Course, CourseGrade> buildGradeMap(List<CourseGrade> grades) {
        Map gradesMap = CollectUtils.newHashMap();
        CourseGrade old = null;
        for (CourseGrade grade : grades) {
            if (!GradeComparator.betterThan(grade, old = (CourseGrade)gradesMap.get(grade.getCourse()))) continue;
            if (null != old) {
                CourseGrade cloned = grade;
                if (grade.getSemester().after(old.getSemester())) {
                    cloned = this.clone(grade);
                    cloned.setSemester(old.getSemester());
                }
                gradesMap.put(grade.getCourse(), cloned);
                continue;
            }
            gradesMap.put(grade.getCourse(), grade);
        }
        return gradesMap;
    }

    private CourseGrade clone(CourseGrade grade) {
        CourseGrade cloned = new CourseGrade();
        cloned.setStd(grade.getStd());
        cloned.setCourse(grade.getCourse());
        cloned.setSemester(grade.getSemester());
        cloned.setClazz(grade.getClazz());
        cloned.setCrn(grade.getCrn());
        cloned.setCourseType(grade.getCourseType());
        cloned.setCourseTakeType(grade.getCourseTakeType());
        cloned.setFreeListening(grade.isFreeListening());
        cloned.setExamMode(grade.getExamMode());
        cloned.setGradingMode(grade.getGradingMode());
        cloned.setProject(grade.getProject());
        cloned.setGp(grade.getGp());
        cloned.setPassed(grade.isPassed());
        cloned.setScore(grade.getScore());
        cloned.setScoreText(grade.getScoreText());
        cloned.setStatus(grade.getStatus());
        cloned.getExamGrades().addAll(grade.getExamGrades());
        return cloned;
    }

    @Override
    public List<CourseGrade> filter(List<CourseGrade> grades) {
        Map<Course, CourseGrade> gradesMap = this.buildGradeMap(grades);
        List<AlternativeCourse> substituteCourses = this.getSubstituteCourses(grades);
        for (AlternativeCourse subCourse : substituteCourses) {
            CourseGrade origin = gradesMap.get(subCourse.getOlds().iterator().next());
            CourseGrade sub = gradesMap.get(subCourse.getNews().iterator().next());
            if (null == origin || null == sub || !GradeComparator.betterThan(sub, origin)) continue;
            gradesMap.remove(sub.getCourse().getId());
            CourseGrade subClone = this.clone(sub);
            subClone.setSemester(origin.getSemester());
            subClone.setCourse(origin.getCourse());
            gradesMap.put(origin.getCourse(), subClone);
        }
        return CollectUtils.newArrayList(gradesMap.values());
    }

    private List<AlternativeCourse> getSubstituteCourses(List<CourseGrade> grades) {
        if (grades.isEmpty()) {
            return Collections.emptyList();
        }
        CourseGrade grade = grades.get(0);
        return this.alternativeCourseService.getAlternativeCourses(grade.getStd());
    }

    public final void setAlternativeCourseService(AlternativeCourseService alternativeCourseService) {
        this.alternativeCourseService = alternativeCourseService;
    }
}

