/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.internal;

import java.util.List;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.openurp.base.edu.code.CourseType;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentScope;
import org.openurp.edu.grade.app.model.AuditSetting;
import org.openurp.edu.grade.plan.service.AuditSettingService;

public class AuditSettingServiceImpl
extends BaseServiceImpl
implements AuditSettingService {
    public AuditSetting getSetting(StudentScope studentScope, CourseType lastType) {
        OqlBuilder query = OqlBuilder.from(AuditSetting.class, (String)"rule");
        query.where("((current_date() between rule.beginOn and rule.endOn) or (current_date() >= rule.beginOn and rule.endOn is null))");
        query.where("rule.studentScope.project = :project", (Object)studentScope.getProject());
        query.where("exists (from rule.studentScope.levels es where es in (:levels))", studentScope.getLevels());
        query.where("exists (from rule.studentScope.stdTypes stdType where stdType in (:stdTypes))", studentScope.getStdTypes());
        List standards = this.entityDao.search((QueryBuilder)query);
        if (standards.size() == 1) {
            return (AuditSetting)((Object)standards.get(0));
        }
        return AuditSetting.empty(lastType);
    }

    @Override
    public AuditSetting getSetting(Student student) {
        StudentScope studentScope = new StudentScope();
        studentScope.setProject(student.getProject());
        studentScope.getLevels().add(student.getLevel());
        studentScope.getStdTypes().add(student.getStdType());
        return this.getSetting(studentScope, null);
    }
}

