/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.listeners;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.code.CourseType;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.plan.model.CourseAuditResult;
import org.openurp.edu.grade.plan.model.GroupAuditResult;
import org.openurp.edu.grade.plan.model.PlanAuditResult;
import org.openurp.edu.grade.plan.service.PlanAuditContext;
import org.openurp.edu.grade.plan.service.PlanAuditListener;
import org.openurp.edu.grade.plan.service.StdGrade;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.PlanCourse;

public class PlanAuditCommonElectiveListener
implements PlanAuditListener {
    @Override
    public void endPlanAudit(PlanAuditContext context) {
        PlanAuditResult result = context.getResult();
        StdGrade stdGrade = context.getStdGrade();
        CourseType electiveType = context.getSetting().getConvertTarget();
        GroupAuditResult groupResult = result.getGroupResult(electiveType);
        if (null == groupResult) {
            GroupAuditResult groupRs = new GroupAuditResult();
            groupRs.setCourseType(electiveType);
            groupRs.setName(electiveType.getName());
            groupRs.setSubCount((short)0);
            groupRs.setIndexno("99.99");
            groupResult = groupRs;
            result.addGroupResult(groupResult);
        }
        Collection<Course> restCourses = stdGrade.getRestCourses();
        for (Course course : restCourses) {
            CourseAuditResult courseResult = new CourseAuditResult();
            courseResult.setCourse(course);
            List<CourseGrade> grades = stdGrade.useGrades(course);
            if (!grades.isEmpty() && !((Integer)grades.get(0).getCourseType().getId()).equals(electiveType.getId())) {
                courseResult.setRemark("\u539f" + grades.get(0).getCourseType().getName());
            }
            courseResult.checkPassed(grades);
            groupResult.addCourseResult(courseResult);
        }
        this.processConvertCredits(groupResult, result, context);
        groupResult.checkPassed(true);
    }

    protected void processConvertCredits(GroupAuditResult target, PlanAuditResult result, PlanAuditContext context) {
        Set parents = CollectUtils.newHashSet();
        Set sibling = CollectUtils.newHashSet();
        for (GroupAuditResult start = target.getParent(); null != start && !parents.contains((Object)start); start = start.getParent()) {
            parents.add(start);
        }
        GroupAuditResult parent = target.getParent();
        if (null != parent) {
            sibling.addAll(parent.getChildren());
            sibling.remove((Object)target);
        }
        float otherConverted = 0.0f;
        float siblingConverted = 0.0f;
        for (GroupAuditResult gr : result.getGroupResults()) {
            if (!context.getSetting().isConvertable(gr.getCourseType()) || gr.equals((Object)target) || parents.contains((Object)gr)) continue;
            if (sibling.contains((Object)gr)) {
                siblingConverted += gr.isPassed() ? gr.getAuditStat().getPassedCredits() - gr.getAuditStat().getRequiredCredits() : 0.0f;
                continue;
            }
            if (null != gr.getParent()) continue;
            otherConverted += gr.isPassed() ? gr.getAuditStat().getPassedCredits() - gr.getAuditStat().getRequiredCredits() : 0.0f;
        }
        target.getAuditStat().setConvertedCredits(otherConverted + siblingConverted);
        for (GroupAuditResult r : parents) {
            r.getAuditStat().setConvertedCredits(otherConverted);
        }
    }

    @Override
    public boolean startPlanAudit(PlanAuditContext context) {
        return true;
    }

    @Override
    public boolean startCourseAudit(PlanAuditContext context, GroupAuditResult groupResult, PlanCourse planCourse) {
        return true;
    }

    @Override
    public boolean startGroupAudit(PlanAuditContext context, CourseGroup courseGroup, GroupAuditResult groupResult) {
        return true;
    }
}

