/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.listeners;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.tuple.Pair;
import org.openurp.base.edu.code.CourseType;
import org.openurp.base.edu.model.Course;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.grade.course.model.CourseGrade;
import org.openurp.edu.grade.plan.model.CourseAuditResult;
import org.openurp.edu.grade.plan.model.GroupAuditResult;
import org.openurp.edu.grade.plan.model.PlanAuditResult;
import org.openurp.edu.grade.plan.service.PlanAuditContext;
import org.openurp.edu.grade.plan.service.PlanAuditListener;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.PlanCourse;

public class PlanAuditCourseTakerListener
implements PlanAuditListener {
    private EntityDao entityDao;
    private static final String TakeCourse2Types = "takeCourse2Types";
    private static final String Group2CoursesKey = "group2CoursesKey";
    private boolean defaultPassed = false;

    @Override
    public boolean startPlanAudit(PlanAuditContext context) {
        OqlBuilder builder = OqlBuilder.from(CourseTaker.class, (String)"ct").where("ct.std=:std", (Object)context.getStd());
        builder.where("not exists(from " + CourseGrade.class.getName() + " cg where cg.semester=ct.clazz.semester and cg.course=ct.clazz.course and cg.std=ct.std and cg.status=:status)", (Object)2);
        builder.where("ct.clazz.semester.endOn >= :now", (Object)new Date());
        builder.select("ct.clazz.course,ct.clazz.courseType");
        Map course2Types = CollectUtils.newHashMap();
        for (Object c : this.entityDao.search((QueryBuilder)builder)) {
            course2Types.put((Course)((Object[])c)[0], (CourseType)((Object)((Object[])c)[1]));
        }
        context.getParams().put(TakeCourse2Types, course2Types);
        context.getParams().put(Group2CoursesKey, new ArrayList());
        return true;
    }

    @Override
    public boolean startGroupAudit(PlanAuditContext context, CourseGroup courseGroup, GroupAuditResult groupResult) {
        return true;
    }

    @Override
    public boolean startCourseAudit(PlanAuditContext context, GroupAuditResult groupResult, PlanCourse planCourse) {
        if (((Map)context.getParams().get(TakeCourse2Types)).containsKey(planCourse.getCourse())) {
            ((ArrayList)context.getParams().get(Group2CoursesKey)).add(new Pair((Object)groupResult, (Object)planCourse.getCourse()));
        }
        return true;
    }

    @Override
    public void endPlanAudit(PlanAuditContext context) {
        Map course2Types = (Map)context.getParams().remove(TakeCourse2Types);
        ArrayList results = (ArrayList)context.getParams().remove(Group2CoursesKey);
        Set used = CollectUtils.newHashSet();
        for (Pair tuple : results) {
            this.add2Group((Course)tuple.getRight(), (GroupAuditResult)((Object)tuple.getLeft()));
            course2Types.remove(tuple.getRight());
            used.add((GroupAuditResult)((Object)tuple.getLeft()));
        }
        GroupAuditResult lastTarget = this.getTargetGroupResult(context);
        for (Map.Entry entry : course2Types.entrySet()) {
            CourseGroup g = context.getCoursePlan().getGroup((CourseType)((Object)entry.getValue()));
            GroupAuditResult gr = null;
            if (null == g || g.getCourseType().isOptional() && !g.isAutoAddup()) {
                gr = context.getResult().getGroupResult((CourseType)((Object)entry.getValue()));
            }
            if (null == gr) {
                gr = lastTarget;
            }
            if (null == gr) continue;
            this.add2Group((Course)entry.getKey(), gr);
            used.add(gr);
        }
        for (GroupAuditResult aur : used) {
            aur.checkPassed(true);
        }
    }

    private void add2Group(Course course, GroupAuditResult groupResult) {
        CourseAuditResult existedResult = null;
        for (CourseAuditResult cr : groupResult.getCourseResults()) {
            if (!cr.getCourse().equals(course)) continue;
            existedResult = cr;
            break;
        }
        if (existedResult == null) {
            existedResult = new CourseAuditResult();
            existedResult.setCourse(course);
            existedResult.setPassed(this.defaultPassed);
            groupResult.addCourseResult(existedResult);
        } else {
            if (this.defaultPassed) {
                existedResult.setPassed(this.defaultPassed);
            }
            existedResult.getGroupResult().updateCourseResult(existedResult);
        }
        if (Strings.isEmpty((CharSequence)existedResult.getRemark())) {
            existedResult.setRemark("\u5728\u8bfb");
        } else {
            existedResult.setRemark(existedResult.getRemark() + "/\u5728\u8bfb");
        }
        if (null == existedResult.getScores()) {
            existedResult.setScores("--");
        }
    }

    private GroupAuditResult getTargetGroupResult(PlanAuditContext context) {
        CourseType electiveType = context.getSetting().getConvertTarget();
        PlanAuditResult result = context.getResult();
        GroupAuditResult groupResult = result.getGroupResult(electiveType);
        if (null == groupResult) {
            GroupAuditResult groupRs = new GroupAuditResult();
            groupRs.setIndexno("99.99");
            groupRs.setCourseType(electiveType);
            groupRs.setName(electiveType.getName());
            groupRs.setSubCount((short)0);
            groupResult = groupRs;
            result.addGroupResult(groupResult);
        }
        return groupResult;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    public boolean isDefaultPassed() {
        return this.defaultPassed;
    }

    public void setDefaultPassed(boolean defaultPassed) {
        this.defaultPassed = defaultPassed;
    }
}

