/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.plan.service.observers;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.openurp.edu.grade.plan.service.PlanAuditContext;
import org.openurp.edu.grade.plan.service.observers.PlanAuditObserver;

public class PlanAuditObserverStack
extends Observable
implements PlanAuditObserver {
    private List<PlanAuditObserver> observers = new ArrayList<PlanAuditObserver>();

    public PlanAuditObserverStack(PlanAuditObserver ... initObersers) {
        for (PlanAuditObserver ob : initObersers) {
            this.addObserver(ob);
        }
    }

    public void addObserver(PlanAuditObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void notifyStart() {
        for (PlanAuditObserver observer : this.observers) {
            observer.notifyStart();
        }
    }

    @Override
    public boolean notifyBegin(PlanAuditContext context, int index) {
        boolean canAudit = true;
        for (PlanAuditObserver observer : this.observers) {
            canAudit &= observer.notifyBegin(context, index);
        }
        return canAudit;
    }

    @Override
    public void notifyEnd(PlanAuditContext context, int index) {
        for (PlanAuditObserver observer : this.observers) {
            observer.notifyEnd(context, index);
        }
    }

    @Override
    public void finish() {
        for (PlanAuditObserver observer : this.observers) {
            observer.finish();
        }
    }

    public List<PlanAuditObserver> getObservers() {
        return this.observers;
    }

    public void setObservers(List<PlanAuditObserver> observers) {
        this.observers = observers;
    }
}

