/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.dao.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.edu.code.CourseType;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.AuditStatus;
import org.openurp.code.service.CodeService;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.StdPlan;
import org.openurp.edu.program.plan.dao.PlanCommonDao;
import org.openurp.edu.program.plan.util.ProgramHibernateClassGetter;
import org.openurp.edu.program.utils.PlanUtils;

public class PlanCommonDaoHibernate
extends HibernateEntityDao
implements PlanCommonDao {
    private CodeService codeService;

    @Override
    public final void removePlan(CoursePlan plan) {
        this.remove(new Object[]{this.get(ProgramHibernateClassGetter.hibernateClass(plan), (Long)plan.getId())});
    }

    @Override
    public final void saveOrUpdatePlan(CoursePlan plan) {
        this.saveSetting(plan);
        this.saveOrUpdate(new Object[]{plan});
        plan.setCredits(this.statPlanCredits(plan));
        this.saveOrUpdate(new Object[]{plan});
    }

    protected void saveSetting(CoursePlan plan) {
        if (plan instanceof ExecutionPlan) {
            ExecutionPlan mplan = (ExecutionPlan)plan;
            if (null == mplan.getProgram().getStatus()) {
                mplan.getProgram().setStatus(AuditStatus.UNSUBMITTED);
            }
        } else if (plan instanceof StdPlan) {
            StdPlan pplan = (StdPlan)plan;
            pplan.setStatus(AuditStatus.UNSUBMITTED);
        }
    }

    @Override
    public float statPlanCredits(CoursePlan plan) {
        float totalCredits = 0.0f;
        if (plan.getTopCourseGroups() != null) {
            for (CourseGroup group : plan.getTopCourseGroups()) {
                totalCredits += group.getCredits();
            }
        }
        return totalCredits;
    }

    @Override
    public boolean hasCourse(CourseGroup cgroup, Course course) {
        return this.hasCourse(cgroup, course, null);
    }

    @Override
    public boolean hasCourse(CourseGroup cgroup, Course course, PlanCourse planCourse) {
        List res;
        OqlBuilder query = OqlBuilder.from(ProgramHibernateClassGetter.hibernateClass(cgroup), (String)"cGroup");
        query.select("select distinct planCourse").join("cGroup.planCourses", "planCourse").where("cGroup.id = :cGroupId", (Object)cgroup.getId()).where("planCourse.course = :course", (Object)course);
        if (planCourse != null) {
            query.where("planCourse <> :planCourse", (Object)planCourse);
        }
        return !(res = this.search((QueryBuilder)query)).isEmpty();
    }

    @Override
    public Set<String> getUsedCourseTypeNames(CoursePlan plan) {
        return plan.getGroups().stream().map(x -> x.getName()).collect(Collectors.toSet());
    }

    @Override
    public List<CourseType> getUnusedCourseTypes(CoursePlan plan) {
        List<CourseType> allCourseTypes = this.codeService.getCodes(CourseType.class);
        List usedCourseTypes = plan.getGroups().stream().map(x -> x.getCourseType()).collect(Collectors.toList());
        allCourseTypes.removeAll(usedCourseTypes);
        return allCourseTypes;
    }

    @Override
    public Set<String> getUnusedCourseTypeNames(CoursePlan plan) {
        Set<String> allCourseTypes = this.codeService.getCodes(CourseType.class).stream().map(x -> x.getName()).collect(Collectors.toSet());
        Set<String> usedCourseTypes = this.getUsedCourseTypeNames(plan);
        allCourseTypes.removeAll(usedCourseTypes);
        return allCourseTypes;
    }

    @Override
    public List<Program> getDuplicatePrograms(Program program) {
        OqlBuilder query = OqlBuilder.from(Program.class, (String)"program");
        if (program.isPersisted()) {
            query.where("program.id <> :me", (Object)program.getId());
        }
        query.where("program.grade = :grade", (Object)program.getGrade());
        query.where("program.level.id = :levelId", (Object)program.getLevel().getId());
        if (program.getStdTypes().isEmpty()) {
            query.where("size(program.stdTypes)==0");
        } else {
            query.where("exists(from program.stdTypes as stdType where stdType in(:stdTypes))", program.getStdTypes());
        }
        query.where("program.department.id = :departmentId", (Object)program.getDepartment().getId());
        query.where("program.major.id = :majorId", (Object)program.getMajor().getId());
        if (program.getDirection() != null && program.getDirection().getId() != null) {
            query.where("program.direction.id = :directionId", (Object)program.getDirection().getId());
        } else {
            query.where("program.direction is null");
        }
        return this.search((QueryBuilder)query);
    }

    @Override
    public boolean isDuplicate(Program program) {
        return CollectUtils.isNotEmpty(this.getDuplicatePrograms(program));
    }

    @Override
    public Float getCreditByTerm(ExecutionPlan plan, int term) {
        Range termRange = Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(plan.getTermsCount()));
        if (!termRange.contains((Object)term)) {
            throw new RuntimeException("term out range");
        }
        float credit = 0.0f;
        for (CourseGroup group : plan.getGroups()) {
            credit += PlanUtils.getGroupCredits(group, term);
        }
        return Float.valueOf(credit);
    }

    public void setCodeService(CodeService codeService) {
        this.codeService = codeService;
    }
}

