/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Squad;
import org.openurp.edu.program.model.ExecutionCourseGroup;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.model.ExecutionPlanCourse;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.plan.dao.PlanCommonDao;
import org.openurp.edu.program.plan.service.ExecutionPlanQueryBuilder;
import org.openurp.edu.program.plan.service.ExecutionPlanService;

public class ExecutionPlanServiceImpl
extends BaseServiceImpl
implements ExecutionPlanService {
    private PlanCommonDao planCommonDao;

    @Override
    public Set<String> getUnusedCourseTypeNames(ExecutionPlan plan) {
        return this.planCommonDao.getUnusedCourseTypeNames(plan);
    }

    @Override
    public void removeExecutionPlan(ExecutionPlan plan) {
        this.planCommonDao.removePlan(plan);
    }

    @Override
    public void saveOrUpdateExecutionPlan(ExecutionPlan plan) {
        this.planCommonDao.saveOrUpdatePlan(plan);
    }

    @Override
    public float statPlanCredits(Long planId) {
        return this.statPlanCredits((ExecutionPlan)this.entityDao.get(ExecutionPlan.class, (Serializable)planId));
    }

    @Override
    public float statPlanCredits(ExecutionPlan plan) {
        return this.planCommonDao.statPlanCredits(plan);
    }

    @Override
    public boolean hasCourse(ExecutionCourseGroup cgroup, Course course) {
        return this.planCommonDao.hasCourse(cgroup, course);
    }

    @Override
    public boolean hasCourse(ExecutionCourseGroup cgroup, Course course, PlanCourse planCourse) {
        return this.planCommonDao.hasCourse(cgroup, course, planCourse);
    }

    public void setPlanCommonDao(PlanCommonDao planCommonDao) {
        this.planCommonDao = planCommonDao;
    }

    @Override
    public ExecutionPlan getExecutionPlanByAdminClass(Squad clazz) {
        List res = this.entityDao.search(ExecutionPlanQueryBuilder.build(clazz));
        return CollectUtils.isEmpty((Collection)res) ? null : (ExecutionPlan)res.get(0);
    }

    @Override
    public List<ExecutionPlanCourse> getPlanCourses(ExecutionPlan plan) {
        if (CollectUtils.isEmpty(plan.getGroups())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ExecutionPlanCourse> planCourses = new ArrayList<ExecutionPlanCourse>();
        for (ExecutionCourseGroup executionCourseGroup : plan.getGroups()) {
            planCourses.addAll(executionCourseGroup.getPlanCourses());
        }
        return planCourses;
    }
}

