/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.service.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.openurp.base.edu.code.CourseType;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.ExecutionCourseGroup;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.model.ExecutionPlanCourse;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.StdCourseGroup;
import org.openurp.edu.program.model.StdPlan;
import org.openurp.edu.program.model.StdPlanCourse;
import org.openurp.edu.program.plan.dao.PlanCommonDao;
import org.openurp.edu.program.plan.dao.PlanCourseCommonDao;
import org.openurp.edu.program.plan.dao.PlanCourseGroupCommonDao;
import org.openurp.edu.program.plan.service.PersonalPlanCompareService;
import org.openurp.edu.program.plan.service.PersonalPlanSyncException;
import org.openurp.edu.program.plan.service.PlanCompareService;

public class PersonalPlanCompareServiceImpl
extends BaseServiceImpl
implements PersonalPlanCompareService {
    private PlanCommonDao planCommonDao;
    private PlanCourseCommonDao planCourseCommonDao;
    private PlanCourseGroupCommonDao planCourseGroupCommonDao;
    private PlanCompareService planCompareService;

    @Override
    public Map<String, List<? extends PlanCourse>[]> diffPersonalAndExecutionPlan(ExecutionPlan executePlan, StdPlan stdExecutionPlan) {
        return this.planCompareService.diff(executePlan, stdExecutionPlan);
    }

    @Override
    public void copyCourseGroups(ExecutionPlan fromPlan, StdPlan toPlan, List<Integer> courseTypeIds) throws PersonalPlanSyncException {
        this.copyCourseGroups(fromPlan, toPlan, courseTypeIds, true);
    }

    @Override
    public void copyPlanCourses(ExecutionPlan fromPlan, StdPlan toPlan, List<Number[]> courseTypePlanCourseIds) throws PersonalPlanSyncException {
        for (Number[] courseTypePlanCourseId : courseTypePlanCourseIds) {
            ExecutionPlanCourse sourcePlanCourse;
            Integer courseTypeId = courseTypePlanCourseId[0].intValue();
            CourseType type = (CourseType)this.entityDao.get(CourseType.class, (Serializable)courseTypeId);
            if (fromPlan.getGroup(type) == null) {
                throw new PersonalPlanSyncException("fromPlan doesn't have this kind of course stdType's course group: " + type.toString());
            }
            if (toPlan.getGroup(type) == null) {
                this.copyCourseGroups(fromPlan, toPlan, Collections.singletonList(courseTypeId), false);
            }
            if ((sourcePlanCourse = (ExecutionPlanCourse)this.entityDao.get(ExecutionPlanCourse.class, (Serializable)((Long)courseTypePlanCourseId[1]))) == null) {
                throw new PersonalPlanSyncException("Cannot find PlanCourse");
            }
            this.planCourseGroupCommonDao.copyPlanCourse(sourcePlanCourse, toPlan.getGroup(type), StdPlanCourse.class);
            toPlan.setCredits(this.planCommonDao.statPlanCredits(toPlan));
            this.planCommonDao.saveOrUpdatePlan(toPlan);
            this.entityDao.refresh((Object)toPlan);
        }
    }

    private void copyCourseGroups(ExecutionPlan fromPlan, StdPlan toPlan, List<Integer> courseTypeIds, boolean copyPlanCourses) throws PersonalPlanSyncException {
        for (Integer typeId : courseTypeIds) {
            CourseGroup sourceGroup;
            CourseType type = (CourseType)this.entityDao.get(CourseType.class, (Serializable)typeId);
            if (fromPlan.getGroup(type) == null) {
                throw new PersonalPlanSyncException("\u6e90\u8ba1\u5212\u4e0d\u5b58\u5728\u8bfe\u7a0b\u7c7b\u522b\uff1a" + type.toString());
            }
            if (toPlan.getGroup(type) != null) {
                this.deleteCourseGroups(toPlan, Collections.singletonList(typeId));
            }
            if ((sourceGroup = fromPlan.getGroup(type)) == null) {
                throw new PersonalPlanSyncException("\u6e90\u8ba1\u5212\u4e0d\u5b58\u5728\u8bfe\u7a0b\u7c7b\u522b\uff1a" + type.toString());
            }
            CourseGroup copy = null;
            if (sourceGroup.getParent() != null) {
                if (toPlan.getGroup(sourceGroup.getParent().getCourseType()) == null) {
                    throw new PersonalPlanSyncException("\u8bf7\u5148\u590d\u5236\u7236\u8bfe\u7a0b\u7ec4\uff1a" + sourceGroup.getParent().getCourseType().getName());
                }
                copy = this.planCourseGroupCommonDao.copyCourseGroup(sourceGroup, toPlan.getGroup(sourceGroup.getParent().getCourseType()), toPlan, StdCourseGroup.class, StdPlanCourse.class);
            } else {
                copy = this.planCourseGroupCommonDao.copyCourseGroup((ExecutionCourseGroup)sourceGroup, null, toPlan, StdCourseGroup.class, StdPlanCourse.class);
            }
            if (copy == null) {
                throw new PersonalPlanSyncException("\u590d\u5236\u8bfe\u7a0b\u7ec4\u5931\u8d25\uff1a" + type.toString());
            }
            if (!copyPlanCourses) {
                copy.getPlanCourses().clear();
            }
            this.planCourseGroupCommonDao.updateGroupTreeCredits(this.planCourseGroupCommonDao.getTopGroup(copy));
            toPlan.setCredits(this.planCommonDao.statPlanCredits(toPlan));
            this.entityDao.saveOrUpdate(new Object[]{toPlan});
            this.entityDao.refresh((Object)toPlan);
        }
    }

    @Override
    public void deleteCourseGroups(StdPlan plan, List<Integer> courseTypeIds) throws PersonalPlanSyncException {
        for (Integer typeId : courseTypeIds) {
            CourseType type = (CourseType)this.entityDao.get(CourseType.class, (Serializable)typeId);
            CourseGroup group = plan.getGroup(type);
            if (group == null) {
                throw new PersonalPlanSyncException("\u6e90\u8ba1\u5212\u4e0d\u5b58\u5728\u8bfe\u7a0b\u7c7b\u522b\uff1a" + type.toString());
            }
            this.planCourseGroupCommonDao.removeCourseGroup((ExecutionCourseGroup)group);
            plan.setCredits(this.planCommonDao.statPlanCredits(plan));
            this.entityDao.saveOrUpdate(new Object[]{plan});
            this.entityDao.refresh((Object)plan);
        }
    }

    @Override
    public void deletePlanCourses(StdPlan plan, List<Number[]> courseTypePlanCourseIds) throws PersonalPlanSyncException {
        for (Number[] courseTypePlanCourseId : courseTypePlanCourseIds) {
            CourseType type = (CourseType)this.entityDao.get(CourseType.class, (Serializable)Integer.valueOf(courseTypePlanCourseId[0].intValue()));
            CourseGroup group = plan.getGroup(type);
            if (group == null) {
                throw new PersonalPlanSyncException("\u6e90\u8ba1\u5212\u4e0d\u5b58\u5728\u8bfe\u7a0b\u7c7b\u522b\uff1a" + type.toString());
            }
            StdPlanCourse toBeRemoved = (StdPlanCourse)this.entityDao.get(StdPlanCourse.class, (Serializable)Long.valueOf(courseTypePlanCourseId[1].longValue()));
            if (toBeRemoved == null) {
                throw new PersonalPlanSyncException("\u65e0\u6cd5\u627e\u5230\u8ba1\u5212\u8bfe\u7a0b");
            }
            this.planCourseCommonDao.removePlanCourse(toBeRemoved, plan);
            this.entityDao.refresh((Object)plan);
        }
    }

    public void setPlanCourseGroupCommonDao(PlanCourseGroupCommonDao planCourseGroupCommonDao) {
        this.planCourseGroupCommonDao = planCourseGroupCommonDao;
    }

    public void setPlanCourseCommonDao(PlanCourseCommonDao planCourseCommonDao) {
        this.planCourseCommonDao = planCourseCommonDao;
    }

    public void setPlanCompareService(PlanCompareService planCompareService) {
        this.planCompareService = planCompareService;
    }

    public void setPlanCommonDao(PlanCommonDao planCommonDao) {
        this.planCommonDao = planCommonDao;
    }
}

