/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.edu.model.Course;
import org.openurp.base.time.Terms;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.model.ExecutionPlanCourse;
import org.openurp.edu.program.model.PlanCourse;

public class PlanUtils {
    public static List<Course> getCourses(ExecutionPlan plan, int term) {
        HashSet<Course> courses = new HashSet<Course>();
        for (ExecutionPlanCourse planCourse : PlanUtils.getPlanCourses(plan)) {
            if (PlanUtils.isUnplannedTerm(planCourse.getTerms()) || !planCourse.getTerms().contains(term)) continue;
            courses.add(planCourse.getCourse());
        }
        return new ArrayList<Course>(courses);
    }

    public static List<ExecutionPlanCourse> getPlanCourses(ExecutionPlan plan) {
        if (CollectUtils.isEmpty(plan.getGroups())) {
            return CollectUtils.newArrayList();
        }
        ArrayList<ExecutionPlanCourse> planCourses = new ArrayList<ExecutionPlanCourse>();
        for (CourseGroup courseGroup : plan.getGroups()) {
            if (null == courseGroup) continue;
            planCourses.addAll(courseGroup.getPlanCourses());
        }
        return planCourses;
    }

    public static List<ExecutionPlanCourse> getUnPlannedPlanCourses(ExecutionPlan plan) {
        if (CollectUtils.isEmpty(plan.getGroups())) {
            return CollectUtils.newArrayList();
        }
        ArrayList<ExecutionPlanCourse> planCourses = new ArrayList<ExecutionPlanCourse>();
        for (CourseGroup courseGroup : plan.getGroups()) {
            if (courseGroup.getPlanCourses() == null || courseGroup.getPlanCourses().size() <= 0) continue;
            for (PlanCourse pcourse : courseGroup.getPlanCourses()) {
                if (!PlanUtils.isUnplannedTerm(pcourse.getTerms())) continue;
                planCourses.add((ExecutionPlanCourse)pcourse);
            }
        }
        return planCourses;
    }

    public static List<ExecutionPlanCourse> getPlannedCourse(ExecutionPlan plan) {
        if (CollectUtils.isEmpty(plan.getGroups())) {
            return CollectUtils.newArrayList();
        }
        ArrayList<ExecutionPlanCourse> planCourses = new ArrayList<ExecutionPlanCourse>();
        for (CourseGroup courseGroup : plan.getGroups()) {
            if (courseGroup.getPlanCourses() == null || courseGroup.getPlanCourses().size() <= 0) continue;
            for (PlanCourse pcourse : courseGroup.getPlanCourses()) {
                if (!PlanUtils.isUnplannedTerm(pcourse.getTerms())) continue;
                planCourses.add((ExecutionPlanCourse)pcourse);
            }
        }
        return planCourses;
    }

    public static boolean isUnplannedTerm(Terms terms) {
        return null == terms || terms.value <= 1;
    }

    public static float getGroupCredits(CourseGroup group, int term) {
        String[] terms = group.getTermCredits().replaceAll("^,", "").replaceAll(",$", "").split(",");
        if (term > terms.length || term < 1) {
            return 0.0f;
        }
        return Float.valueOf(terms[term - 1]).floatValue();
    }

    public static List<ExecutionPlanCourse> getPlanCourses(ExecutionPlan plan, int term) {
        ArrayList<ExecutionPlanCourse> planCourses = new ArrayList<ExecutionPlanCourse>();
        for (ExecutionPlanCourse planCourse : PlanUtils.getPlanCourses(plan)) {
            if (!PlanUtils.openOnThisTerm(planCourse.getTerms(), term)) continue;
            planCourses.add(planCourse);
        }
        return planCourses;
    }

    public static List<PlanCourse> getPlanCourses(CourseGroup group, int term) {
        ArrayList<PlanCourse> result = new ArrayList<PlanCourse>();
        for (PlanCourse pCourse : group.getPlanCourses()) {
            if (!PlanUtils.openOnThisTerm(pCourse.getTerms(), term)) continue;
            result.add(pCourse);
        }
        return result;
    }

    public static boolean openOnThisTerm(Terms terms, int term) {
        return terms.contains(term);
    }

    public static List<PlanCourse> getPlanCoursesUntilTerm(CourseGroup courseGroup, int term) {
        Set result = CollectUtils.newHashSet();
        for (int i = 1; i <= term; ++i) {
            result.addAll(PlanUtils.getPlanCourses(courseGroup, i));
        }
        return new ArrayList<PlanCourse>(result);
    }
}

