/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.room.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.orm.hibernate.udt.WeekTime;
import org.openurp.base.model.Room;
import org.openurp.edu.room.service.RoomResourceService;

public class RoomResourceServiceImpl
extends BaseServiceImpl
implements RoomResourceService {
    @Override
    public List<Room> getFreeRooms(Collection<Room> rooms, WeekTime unit) {
        OqlBuilder query = OqlBuilder.from(Room.class, (String)"classroom");
        query.where("not exists(select 1 from org.openurp.edu.room.model.Occupancy occupancy where occupancy.room = classroom.room and (occupancy.time.startOn = :startOn) and (occupancy.time.weekstate = :weekState) and (:startTime <= occupancy.time.endAt and :endTime > occupancy.time.beginAt))");
        if (!CollectUtils.isEmpty(rooms)) {
            query.where("classroom in (:rooms)");
        }
        query.where("classroom.beginOn <= :now and (classroom.endOn is null or classroom.endOn >= :now)");
        query.orderBy("classroom.code");
        Map params = CollectUtils.newHashMap();
        params.put("startOn", unit.getStartOn());
        params.put("weekState", unit.getWeekstate());
        params.put("startTime", unit.getBeginAt().value);
        params.put("endTime", unit.getEndAt().value);
        if (!CollectUtils.isEmpty(rooms)) {
            params.put("rooms", rooms);
        }
        params.put("now", new Date());
        query.params(params);
        return this.entityDao.search((QueryBuilder)query);
    }
}

