/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.Order;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.orm.hibernate.udt.WeekTime;
import org.openurp.base.edu.model.Classroom;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.edu.model.Teacher;
import org.openurp.base.model.Department;
import org.openurp.base.model.Room;
import org.openurp.base.std.model.Squad;
import org.openurp.base.std.model.Student;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.clazz.model.ClazzActivity;
import org.openurp.edu.clazz.model.Restriction;
import org.openurp.edu.clazz.model.RestrictionMeta;
import org.openurp.edu.clazz.service.CourseLimitUtils;
import org.openurp.edu.service.TeachResourceService;
import org.openurp.service.security.DataRealm;

public class TeachResourceServiceImpl
extends BaseServiceImpl
implements TeachResourceService {
    @Override
    public boolean isStdOccupied(WeekTime time, Long stdId) {
        return false;
    }

    @Override
    public boolean isStdsOccupied(WeekTime time, Collection stdIds) {
        return false;
    }

    @Override
    public boolean isStdsOccupied(WeekTime time, Collection stdIds, Clazz expect) {
        return false;
    }

    @Override
    public boolean isRoomOccupied(WeekTime time, Serializable roomId) {
        return false;
    }

    @Override
    public boolean isSessionRoomOccupied(ClazzActivity activity) {
        return false;
    }

    @Override
    public boolean isTeacherOccupied(WeekTime time, Long teacherId) {
        return false;
    }

    @Override
    public boolean isSquadOccupied(WeekTime time, Long adminClassId) {
        return false;
    }

    @Override
    public boolean isSquadesOccupied(WeekTime time, Collection adminClasses) {
        return false;
    }

    @Override
    public Collection getFreeRoomsIn(Collection roomIds, WeekTime[] times, Room room) {
        return null;
    }

    @Override
    public OqlBuilder<Classroom> getFreeRoomsOf(OqlBuilder<Classroom> query, Map<String, Object> params, List<Department> departs, WeekTime unit, List<Classroom> rooms) {
        query.where("not exists(select 1 from org.openurp.edu.room.model.Occupancy occupancy where occupancy.room = classroom.room and (occupancy.time.startOn = :startOn) and bitand(occupancy.time.weekstate , :weekState)>0 and (:startTime <= occupancy.time.endAt and :endTime > occupancy.time.beginAt))");
        query.where("classroom.beginOn <= :now and (classroom.endOn is null or classroom.endOn >= :now)");
        query.join("classroom.departments", "depart");
        query.where("depart in (:departs)");
        query.select("distinct classroom");
        if (!rooms.isEmpty()) {
            query.where("classroom not in (:rooms)");
        }
        params.put("startOn", unit.getStartOn());
        params.put("weekState", unit.getWeekstate());
        params.put("startTime", unit.getBeginAt());
        params.put("endTime", unit.getEndAt());
        params.put("now", new Date());
        params.put("departs", departs);
        if (!rooms.isEmpty()) {
            params.put("rooms", rooms);
        }
        query.params(params);
        return null;
    }

    @Override
    public Collection getFreeRoomsOf(Project project, Long[] departIds, WeekTime[] times, Room room, PageLimit limit, Order order) {
        OqlBuilder query = OqlBuilder.from(Classroom.class, (String)"room");
        query.where("room.building.department.id in (:departs)", (Object)departIds);
        query.where("not exists (select 1 from org.openurp.edu.room.model.Occupancy occ where occ.time in (:times) and room.room = occ.room)", (Object)times);
        query.limit(limit);
        query.orderBy(order);
        return this.entityDao.search((QueryBuilder)query);
    }

    @Override
    public Collection getFreeTeachersIn(Collection teacherIds, WeekTime[] times, Teacher teacher) {
        return null;
    }

    @Override
    public Collection<Teacher> getFreeTeachersOf(Project project, WeekTime[] times, Teacher teacher, Teacher replaceTeacher, PageLimit pageLimit, String order) {
        OqlBuilder builder = OqlBuilder.from(Teacher.class, (String)"teacher");
        if (null != replaceTeacher) {
            builder.where("teacher!= :replaceTeacher", (Object)replaceTeacher);
        }
        if (null != teacher) {
            if (Strings.isNotEmpty((CharSequence)teacher.getCode())) {
                builder.where(new Condition[]{Condition.like((String)"teacher.staff.code", (String)teacher.getCode())});
            }
            if (Strings.isNotEmpty((CharSequence)teacher.getName())) {
                builder.where(new Condition[]{Condition.like((String)"teacher.name", (String)teacher.getName())});
            }
            if (null != teacher.getDepartment()) {
                builder.where("teacher.department = :deparment", (Object)teacher.getDepartment());
            }
        }
        StringBuilder hql = new StringBuilder("not exists (from org.openurp.edu.clazz.model.Clazz clazz join clazz.schedule.activities activity join activity.teachers actTeacher where actTeacher=teacher ");
        Object occupy = "";
        for (int i = 0; i < times.length; ++i) {
            occupy = "(activity.time.startOn=:startOn" + i + " and bitand(activity.time.weekstate," + new Long(times[i].getWeekstate().value) + ")>0  and " + times[i].getBeginAt().value + " <= activity.time.endAt and " + times[i].getEndAt().value + " > activity.time.beginAt)";
            if (i > 0) {
                hql.append(" or ");
            } else if (i == 0) {
                hql.append(" and (");
            }
            hql.append((String)occupy);
            builder.param("startOn" + i, (Object)times[i].getStartOn());
        }
        hql.append("))");
        if (times.length > 0) {
            builder.where(hql.toString());
        }
        builder.limit(pageLimit).orderBy(order);
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public List<ClazzActivity> getSquadActivities(Squad squad, WeekTime time, Semester semester) {
        OqlBuilder builder = OqlBuilder.from(ClazzActivity.class, (String)"activity");
        builder.where("activity.clazz.semester =:semester", (Object)semester);
        builder.where("activity.clazz.project.id=:projectId", (Object)squad.getProject().getId());
        this.setTimeQuery(time, (OqlBuilder<ClazzActivity>)builder);
        Condition con = CourseLimitUtils.build(RestrictionMeta.Squad, "lgi", ((Long)squad.getId()).toString());
        List params = con.getParams();
        builder.where("exists(from " + Restriction.class.getName() + " lg  join lg.items as lgi where lg.clazz=activity.clazz and " + con.getContent() + ")", params.get(0), params.get(1), params.get(2), new Object[0]);
        return this.entityDao.search((QueryBuilder)builder);
    }

    protected void setTimeQuery(WeekTime time, OqlBuilder<ClazzActivity> builder) {
        if (time != null) {
            if (null != time.getStartOn()) {
                builder.where("activity.time.startOn =:startOn", (Object)time.getStartOn());
            }
            if (null != time.getEndAt()) {
                builder.where("activity.time.endAt =:endUnit", (Object)time.getEndAt());
            }
            if (null != time.getBeginAt()) {
                builder.where("activity.time.beginAt =:startUnit", (Object)time.getBeginAt());
            }
            if (null != time.getWeekstate() && 0L < time.getWeekstate().value) {
                builder.where("bitand(activity.time.weekstate," + time.getWeekstate().value + ")>0");
            }
        }
    }

    @Override
    public List<ClazzActivity> getTeacherActivities(Teacher teacher, WeekTime time, Semester semester) {
        OqlBuilder builder = OqlBuilder.from(ClazzActivity.class, (String)"activity");
        builder.join("activity.teachers", "teacher");
        builder.where("activity.clazz.semester =:semester", (Object)semester);
        this.setTimeQuery(time, (OqlBuilder<ClazzActivity>)builder);
        builder.where("teacher = :teacher", (Object)teacher);
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public List<ClazzActivity> getRoomActivities(Classroom room, WeekTime time, Semester semester) {
        OqlBuilder builder = OqlBuilder.from(ClazzActivity.class, (String)"activity");
        builder.join("activity.rooms", "room");
        builder.where("activity.clazz.semester =:semester", (Object)semester);
        this.setTimeQuery(time, (OqlBuilder<ClazzActivity>)builder);
        builder.where("room = :room", (Object)room);
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public List<ClazzActivity> getRoomActivities(Classroom room, WeekTime time, Semester semester, List<Department> departments, Project project) {
        OqlBuilder builder = OqlBuilder.from(ClazzActivity.class, (String)"activity");
        builder.join("activity.rooms", "room");
        builder.where("activity.clazz.semester =:semester", (Object)semester);
        if (CollectUtils.isNotEmpty(departments)) {
            builder.where("activity.clazz.teachDepart in (:departments)", departments);
        }
        if (null != project) {
            builder.where("activity.clazz.project = :project", (Object)project);
        }
        this.setTimeQuery(time, (OqlBuilder<ClazzActivity>)builder);
        builder.where("room = :room", (Object)room);
        return this.entityDao.search((QueryBuilder)builder);
    }

    @Override
    public List<ClazzActivity> getStdActivities(Student student, WeekTime time, Semester semester) {
        OqlBuilder builder = OqlBuilder.from(ClazzActivity.class, (String)"activity");
        builder.join("activity.clazz.enrollment.courseTakers", "taker");
        builder.where("activity.clazz.semester =:semester", (Object)semester);
        this.setTimeQuery(time, (OqlBuilder<ClazzActivity>)builder);
        builder.where("taker.std = :student", (Object)student);
        return this.entityDao.search((QueryBuilder)builder);
    }

    public List getRoomActivities(Serializable roomId, WeekTime time, Class activityClass, Semester semester) {
        return null;
    }

    @Override
    public List getStdActivities(Long stdId, WeekTime time, Class activityClass, Semester semester) {
        return null;
    }

    @Override
    public List getRoomOccupyInfos(Integer roomId, Long weekStateNum, Integer year) {
        return null;
    }

    @Override
    public List getTeacherOccupyInfos(Long teacherId, Long weekStateNum, Integer year) {
        return null;
    }

    @Override
    public List getSquadOccupyInfos(Long adminClassId, Long weekStateNum, Integer year) {
        return null;
    }

    @Override
    public List getClassrooms(Collection roomIds) {
        return null;
    }

    @Override
    public List getTeachers(Collection teacherIds) {
        return null;
    }

    @Override
    public List getClassrooms(String roomIdSeq) {
        return null;
    }

    @Override
    public List getClassrooms(Integer[] roomIds) {
        return null;
    }

    @Override
    public Map<ClazzActivity, Object[]> getElectCountRoomUtilizationOfCourse(List<Department> departments, Semester semester, Float ratio) {
        OqlBuilder builder = OqlBuilder.from(ClazzActivity.class, (String)"activity").where("activity.clazz.semester=:semester", (Object)semester).where("activity.clazz.teachDepart in (:depart)", departments);
        List activitys = this.entityDao.search((QueryBuilder)builder);
        Map utilizations = CollectUtils.newHashMap();
        for (ClazzActivity courseActivity : activitys) {
            Set<Classroom> rooms = courseActivity.getRooms();
            int capacity = 0;
            for (Classroom room : rooms) {
                capacity += room.getCourseCapacity();
            }
            Object[] objs = new Object[2];
            objs[1] = capacity;
            if (capacity != 0) {
                Float ratioNow = Float.valueOf((float)courseActivity.getClazz().getEnrollment().getStdCount() / (float)capacity);
                if (!(ratioNow.floatValue() <= ratio.floatValue())) continue;
                objs[0] = ratioNow;
                utilizations.put(courseActivity, objs);
                continue;
            }
            objs[0] = Float.valueOf(0.0f);
            utilizations.put(courseActivity, objs);
        }
        return utilizations;
    }

    @Override
    public Map<ClazzActivity, Object[]> getRoomUtilizationOfCourse(List<Department> departments, Semester semester, Float ratio) {
        OqlBuilder builder = OqlBuilder.from(ClazzActivity.class, (String)"activity").where("activity.clazz.semester=:semester", (Object)semester).where("activity.clazz.teachDepart in (:depart)", departments);
        List activitys = this.entityDao.search((QueryBuilder)builder);
        Map utilizations = CollectUtils.newHashMap();
        for (ClazzActivity courseActivity : activitys) {
            Set<Classroom> rooms = courseActivity.getRooms();
            int capacity = 0;
            for (Classroom room : rooms) {
                capacity += room.getCourseCapacity();
            }
            Object[] objs = new Object[2];
            objs[1] = capacity;
            if (capacity != 0) {
                Float ratioNow = Float.valueOf((float)courseActivity.getClazz().getEnrollment().getCapacity() / (float)capacity);
                if (!(ratioNow.floatValue() <= ratio.floatValue())) continue;
                objs[0] = ratioNow;
                utilizations.put(courseActivity, objs);
                continue;
            }
            objs[0] = Float.valueOf(0.0f);
            utilizations.put(courseActivity, objs);
        }
        return utilizations;
    }

    @Override
    public Collection<Squad> querySquadByOccupyInfo(Semester semester, Integer startWeek, Integer endWeek, Integer startWeekDay, Integer endWeekDay, Integer startUnit, Integer endUnit, boolean busy, DataRealm dataRealm) {
        return null;
    }

    @Override
    public int getTeacherPeriod(Clazz clazz, Teacher teacher) {
        Set<ClazzActivity> courseActivities = clazz.getSchedule().getActivities();
        int period = 0;
        for (ClazzActivity courseActivity : courseActivities) {
            if (!courseActivity.getTeachers().contains((Object)teacher)) continue;
            WeekTime time = courseActivity.getTime();
            period = (int)((double)period + Math.ceil((double)time.getEndAt().interval(time.getBeginAt()) / 45.0) * (double)time.getWeekstate().getWeeks());
        }
        return period;
    }
}

