/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.util;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.service.SemesterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermCalculator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SemesterService semesterService;
    private Map<String, Integer> termCalcCache;
    private Semester semester;
    private static Map<String, Set<Integer>> termMap = CollectUtils.newHashMap();

    public static final boolean inTerm(String termStr, Integer term) {
        if (Strings.contains((CharSequence)termStr, (CharSequence)"*")) {
            return true;
        }
        Set<Integer> termSet = termMap.get(termStr);
        if (null == termSet) {
            String[] terms = Strings.split((String)termStr, (String)",");
            termSet = new HashSet<Integer>(3);
            for (String one : terms) {
                termSet.add(Numbers.toInt((String)one));
            }
            termMap.put(termStr, termSet);
        }
        return termSet.contains(term);
    }

    public static final boolean lessOrEqualTerm(String termStr, Integer term) {
        if (Strings.contains((CharSequence)termStr, (CharSequence)"*")) {
            return true;
        }
        Set<Integer> termSet = termMap.get(termStr);
        if (null == termSet) {
            String[] terms = Strings.split((String)termStr, (String)",");
            termSet = new HashSet<Integer>(3);
            for (String one : terms) {
                termSet.add(Numbers.toInt((String)one));
            }
            termMap.put(termStr, termSet);
        }
        for (Integer t : termSet) {
            if (t.compareTo(term) > 0) continue;
            return true;
        }
        return false;
    }

    public TermCalculator(SemesterService semesterService, Semester semester) {
        this.semesterService = semesterService;
        this.termCalcCache = CollectUtils.newHashMap();
        this.semester = semester;
        this.semester.getCalendar().getId();
    }

    public int getTermBetween(Semester pre, Semester post, boolean omitSmallTerm) {
        return this.semesterService.getTermsBetween(pre, post, omitSmallTerm);
    }

    public int getTerm(Date begOn, Date endOn, boolean omitSmallTerm) {
        Integer term = this.termCalcCache.get(begOn.toString() + "~" + endOn.toString());
        if (term != null) {
            return term;
        }
        Semester enrollSemester = this.semesterService.getSemester(this.semester.getCalendar(), new java.sql.Date(begOn.getTime()), new java.sql.Date(endOn.getTime()));
        if (this.logger.isDebugEnabled()) {
            this.logger.info("calculate a term for [{}~{}] and calculate term is " + term, (Object)begOn.toString(), (Object)endOn.toString());
        }
        if (null == enrollSemester) {
            this.logger.info("cannot find enrollterm for grade {}~{}", (Object)begOn.toString(), (Object)endOn.toString());
            term = -1;
        } else {
            term = this.semesterService.getTermsBetween(enrollSemester, this.semester, omitSmallTerm);
        }
        this.logger.info("enrollSemester is " + enrollSemester.getCode());
        this.logger.info("calculate a term for [{}~{}] and calculate term is " + term, (Object)begOn.toString(), (Object)endOn.toString());
        this.termCalcCache.put(begOn.toString() + "~" + endOn.toString(), term);
        return term == null ? -1 : term;
    }

    public int getTerm(Date date1, boolean omitSmallTerm) {
        Integer term = this.termCalcCache.get(date1.toString());
        if (term != null) {
            return term;
        }
        Calendar jCalendar = Calendar.getInstance();
        jCalendar.setTime(date1);
        jCalendar.add(6, 30);
        Date date = jCalendar.getTime();
        Semester enrollSemester = this.semesterService.getSemester(this.semester.getCalendar(), new java.sql.Date(date.getTime()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("calculate a term for [{}]", (Object)date.toString());
        }
        if (null == enrollSemester) {
            this.logger.info("cannot find enrollterm for grade {}", (Object)date.toString());
            term = -1;
        } else {
            term = this.semesterService.getTermsBetween(enrollSemester, this.semester, omitSmallTerm);
        }
        this.termCalcCache.put(date.toString(), term);
        return term == null ? -1 : term;
    }

    static {
        Set autumn = CollectUtils.newHashSet((Object[])new Integer[]{1, 3, 5, 7, 9, 11});
        Set spring = CollectUtils.newHashSet((Object[])new Integer[]{2, 3, 4, 8, 10, 12});
        Set all = CollectUtils.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12});
        termMap.put("\u6625", spring);
        termMap.put("\u79cb", autumn);
        termMap.put("\u6625\u5b63", spring);
        termMap.put("\u6625\u79cb", all);
        termMap.put("\u6625,\u79cb", all);
    }
}

