/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.util.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Objects;
import org.openurp.base.util.stat.StatCountor;
import org.openurp.base.util.stat.StatItem;

public class StatGroup
implements StatCountor {
    Object what;
    List items = new ArrayList();

    public StatGroup(Object entity) {
        this.what = entity;
    }

    public StatGroup(Object entity, List items) {
        this.what = entity;
        this.items = items;
    }

    public void addData(Object[] data, int from, int to, int counters) {
        if (to - from == counters) {
            StatItem statItem = new StatItem(data[from]);
            Comparable[] cts = new Comparable[counters];
            System.arraycopy(data, from + 1, cts, 0, counters);
            statItem.setCountors(cts);
            this.items.add(statItem);
        } else if (to - from > counters) {
            StatGroup subItem = new StatGroup(data[from]);
            int index = this.items.indexOf(subItem);
            if (-1 == index) {
                this.items.add(subItem);
            } else {
                subItem = (StatGroup)this.items.get(index);
            }
            subItem.addData(data, from + 1, to, counters);
        } else {
            return;
        }
    }

    public static List buildStatGroups(List datas) {
        return StatGroup.buildStatGroups(datas, 1);
    }

    public static StatGroup buildStatGroup(List datas, int counters) {
        StatGroup result = new StatGroup(null);
        if (datas != null && !datas.isEmpty()) {
            for (Object[] data : datas) {
                result.addData(data, 0, data.length - 1, counters);
            }
        }
        return result;
    }

    public static List buildStatGroups(List datas, int counters) {
        ArrayList<StatGroup> stats = new ArrayList<StatGroup>();
        if (!CollectUtils.isEmpty((Collection)datas)) {
            HashMap<Object, StatGroup> rs = new HashMap<Object, StatGroup>();
            for (Object[] data : datas) {
                StatGroup result = (StatGroup)rs.get(data[0]);
                if (null == result) {
                    result = new StatGroup(data[0]);
                    rs.put(data[0], result);
                    stats.add(result);
                }
                result.addData(data, 1, data.length - 1, counters);
            }
        }
        return stats;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StatGroup)) {
            return false;
        }
        StatGroup rhs = (StatGroup)object;
        return Objects.equals((Object)this.what, (Object)rhs.what);
    }

    public int hashCode() {
        return null != this.what ? 629 : this.what.hashCode();
    }

    @Override
    public Object getWhat() {
        return this.what;
    }

    public void setWhat(Object entity) {
        this.what = entity;
    }

    public List getItems() {
        return this.items;
    }

    public void setItems(List items) {
        this.items = items;
    }

    public List getItemEntities() {
        ArrayList<Object> entities = new ArrayList<Object>();
        for (StatCountor obj : this.items) {
            entities.add(obj.getWhat());
        }
        return entities;
    }

    public List getSubItemEntities() {
        HashSet entities = new HashSet();
        if (this.items.isEmpty()) {
            return CollectUtils.newArrayList();
        }
        if (this.items.get(0) instanceof StatGroup) {
            for (Object obj : this.items) {
                entities.addAll(((StatGroup)obj).getItemEntities());
            }
        }
        return new ArrayList(entities);
    }

    public Object getItem(Object statWhat) {
        for (StatCountor element : this.items) {
            if (!Objects.equals((Object)element.getWhat(), (Object)statWhat)) continue;
            return element;
        }
        return null;
    }

    public Number sumItemCounter(int counterIndex) {
        double sum = 0.0;
        for (StatItem item : this.items) {
            if (null == item.getCountors()[counterIndex]) continue;
            sum += ((Number)((Object)item.getCountors()[counterIndex])).doubleValue();
        }
        return new Double(sum);
    }
}

