/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.dao.hibernate.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.lang.Strings;
import org.beangle.orm.hibernate.HibernateEntityDao;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.edu.clazz.dao.ClazzCRNGenerator;
import org.openurp.edu.clazz.model.Clazz;

public class CoursePrefixSeqNoGeneratorImpl
extends HibernateEntityDao
implements ClazzCRNGenerator {
    public static final String initSeqNo = "01";
    private static final int tail_length = 2;
    private String infix = ".";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void genClazzSeqNo(Clazz clazz) {
        if (Strings.isNotEmpty((CharSequence)clazz.getCrn())) {
            return;
        }
        String prefix = this.getPrefix(clazz);
        CoursePrefixSeqNoGeneratorImpl coursePrefixSeqNoGeneratorImpl = this;
        synchronized (coursePrefixSeqNoGeneratorImpl) {
            List<String> seqNos = this.getClazzNos(clazz.getProject(), clazz.getSemester(), clazz.getCourse());
            String newSeqNo = "00";
            for (String seqNo : seqNos) {
                if (this.gap(seqNo, newSeqNo) >= 2) break;
                newSeqNo = seqNo;
            }
            newSeqNo = this.rollUp(newSeqNo);
            clazz.setCrn(prefix + this.leftPadding(newSeqNo));
        }
    }

    private List<String> allocate(List<String> seqNos, int count) {
        String newSeqNo = "00";
        int allocated = 0;
        List allocatedSeqnos = CollectUtils.newArrayList();
        for (String seqNo : seqNos) {
            if (this.gap(seqNo, newSeqNo) >= 2) {
                int emptySlots = this.gap(seqNo, newSeqNo) - 1;
                for (int i = 0; i < emptySlots; ++i) {
                    newSeqNo = this.rollUp(newSeqNo);
                    allocatedSeqnos.add(this.leftPadding(newSeqNo));
                    if (++allocated >= count) break;
                }
                if (allocated >= count) break;
            }
            newSeqNo = seqNo;
        }
        while (allocated < count) {
            newSeqNo = this.rollUp(newSeqNo);
            allocatedSeqnos.add(this.leftPadding(newSeqNo));
            ++allocated;
        }
        return allocatedSeqnos;
    }

    protected int gap(String a, String b) {
        if (a.equals("A0") && b.equals("99")) {
            return 1;
        }
        char[] ac = a.toCharArray();
        char[] bc = b.toCharArray();
        return ac[0] * 10 + ac[1] - (bc[0] * 10 + bc[1]);
    }

    protected String rollUp(String a) {
        int tenPos = 0;
        int onePos = 1;
        char[] ac = a.toCharArray();
        if (ac[onePos] < '9') {
            int n = onePos;
            ac[n] = (char)(ac[n] + '\u0001');
        } else {
            ac[onePos] = 48;
            if (ac[tenPos] < '9') {
                int n = tenPos;
                ac[n] = (char)(ac[n] + '\u0001');
            } else if (ac[tenPos] == '9') {
                ac[tenPos] = 65;
            } else if (ac[tenPos] >= 'A') {
                int n = tenPos;
                ac[n] = (char)(ac[n] + '\u0001');
            }
        }
        return String.valueOf(ac);
    }

    @Override
    public synchronized void genClazzSeqNos(Collection<Clazz> clazzes) {
        if (clazzes.isEmpty()) {
            return;
        }
        Map courseClazzes = CollectUtils.newHashMap();
        for (Clazz clazz : clazzes) {
            if (!Strings.isEmpty((CharSequence)clazz.getCrn())) continue;
            ArrayList<Clazz> matches = (ArrayList<Clazz>)courseClazzes.get(clazz.getCourse());
            if (null == matches) {
                matches = new ArrayList<Clazz>();
                courseClazzes.put(clazz.getCourse(), matches);
            }
            matches.add(clazz);
        }
        for (Course course : courseClazzes.keySet()) {
            Collection myClazzes = (Collection)courseClazzes.get(course);
            Clazz firstClazz = (Clazz)myClazzes.iterator().next();
            List<String> allSeqNos = this.getClazzNos(firstClazz.getProject(), firstClazz.getSemester(), course);
            this.genClazzSeqNos(myClazzes, this.getPrefix(firstClazz), allSeqNos);
        }
    }

    protected void genClazzSeqNos(Collection<Clazz> clazzes, String prefix, List<String> seqNos) {
        Iterator<Clazz> clazzIter = clazzes.iterator();
        List<String> newSeqNos = this.allocate(seqNos, clazzes.size());
        for (String seqNo : newSeqNos) {
            Clazz clazz = clazzIter.next();
            clazz.setCrn(prefix + seqNo);
        }
    }

    private String leftPadding(String newSeqNo) {
        return Strings.repeat((String)"0", (int)(2 - newSeqNo.length())) + newSeqNo;
    }

    protected String getPrefix(Clazz clazz) {
        String courseCode = clazz.getCourse().getCode();
        if (Strings.isEmpty((CharSequence)courseCode)) {
            courseCode = ((Course)this.get(Course.class, (Long)clazz.getCourse().getId())).getCode();
        }
        return Strings.isBlank((CharSequence)this.infix) ? courseCode : courseCode + this.infix;
    }

    private List<String> getClazzNos(Project project, Semester semester, Course course) {
        String courseCode = course.getCode();
        if (Strings.isEmpty((CharSequence)courseCode)) {
            courseCode = ((Course)this.get(Course.class, (Long)course.getId())).getCode();
        }
        String select = "substr(clazz.crn," + (courseCode.length() + 1 + (null == this.infix ? 0 : this.infix.length())) + ")";
        OqlBuilder builder = OqlBuilder.from(Clazz.class, (String)"clazz").select(select).where("clazz.project = :project and clazz.semester=:semster", (Object)project, (Object)semester).where("clazz.course=:course and clazz.crn is not null", (Object)course).where("length(" + select + ")=" + initSeqNo.length()).orderBy("clazz.crn");
        return this.search((QueryBuilder)builder);
    }

    public String getInfix() {
        return this.infix;
    }

    public void setInfix(String infix) {
        this.infix = infix;
    }
}

